/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.apache.tapestry5.jpa.EntityManagerSource;
import org.slf4j.Logger;

public class EntityManagerManagerImpl
implements EntityManagerManager,
ThreadCleanupListener {
    private final EntityManagerSource entityManagerSource;
    private final Logger logger;
    private final Map<String, EntityManager> entityManagers = CollectionFactory.newMap();

    public EntityManagerManagerImpl(EntityManagerSource entityManagerSource, Logger logger) {
        this.entityManagerSource = entityManagerSource;
        this.logger = logger;
    }

    @Override
    public EntityManager getEntityManager(String persistenceUnitName) {
        return this.getOrCreateEntityManager(persistenceUnitName);
    }

    @Override
    public Map<String, EntityManager> getEntityManagers() {
        this.createAllEntityManagers();
        return Collections.unmodifiableMap(this.entityManagers);
    }

    private void createAllEntityManagers() {
        for (PersistenceUnitInfo info : this.entityManagerSource.getPersistenceUnitInfos()) {
            this.getOrCreateEntityManager(info.getPersistenceUnitName());
        }
    }

    private EntityManager getOrCreateEntityManager(String persistenceUnitName) {
        EntityManager em = this.entityManagers.get(persistenceUnitName);
        if (em == null) {
            em = this.entityManagerSource.create(persistenceUnitName);
            this.entityManagers.put(persistenceUnitName, em);
        }
        return em;
    }

    public void threadDidCleanup() {
        for (Map.Entry<String, EntityManager> next : this.entityManagers.entrySet()) {
            try {
                EntityManager em = next.getValue();
                if (!em.isOpen()) continue;
                em.close();
            }
            catch (Exception e) {
                this.logger.info(String.format("Failed to close EntityManager for persistence unit '%s'", next.getKey()));
            }
        }
        this.entityManagers.clear();
    }
}

