/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.FsIterator_multiple_indexes;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;

class FsIterator_aggregation_common<T extends FeatureStructure>
extends FsIterator_multiple_indexes<T> {
    private static final AtomicInteger moveTo_error_msg_count = new AtomicInteger(0);
    private int current_it_idx = -1;

    FsIterator_aggregation_common(LowLevelIterator<T>[] iterators, FSIndex<T> index, Comparator<TOP> comparatorMaybeNoTypeWithoutId) {
        super((LowLevelIndex)index, iterators, comparatorMaybeNoTypeWithoutId);
        this.moveToFirstNoReinit();
    }

    FsIterator_aggregation_common(FsIterator_aggregation_common<T> v) {
        super(v);
        this.current_it_idx = v.current_it_idx;
    }

    @Override
    public boolean isMoveToSupported() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.current_it_idx >= 0;
    }

    @Override
    public T getNvc() throws NoSuchElementException {
        return this.nonEmptyIterators[this.current_it_idx].getNvc();
    }

    @Override
    public void moveToNoReinit(FeatureStructure fs) {
        Misc.decreasingWithTrace(moveTo_error_msg_count, "MoveTo operations on unsorted iterators are likely mistakes.", UIMAFramework.getLogger());
        int i = -1;
        int validNonMatch = -1;
        for (LowLevelIterator it : this.nonEmptyIterators) {
            ++i;
            it.moveToNoReinit(fs);
            if (it.isValid() && 0 == it.ll_getIndex().compare(fs, (FeatureStructure)it.getNvc())) {
                this.current_it_idx = i;
                return;
            }
            if (validNonMatch != -1 || !it.isValid()) continue;
            validNonMatch = i;
        }
        if (validNonMatch >= 0) {
            this.current_it_idx = validNonMatch;
            return;
        }
        this.current_it_idx = -1;
    }

    @Override
    public void moveToFirstNoReinit() {
        this.current_it_idx = -1;
        for (LowLevelIterator it : this.nonEmptyIterators) {
            ++this.current_it_idx;
            it.moveToFirstNoReinit();
            if (!it.isValid()) continue;
            return;
        }
    }

    @Override
    public void moveToLastNoReinit() {
        for (int i = this.nonEmptyIterators.length - 1; i >= 0; --i) {
            LowLevelIterator it = this.nonEmptyIterators[i];
            it.moveToLastNoReinit();
            if (!it.isValid()) continue;
            this.current_it_idx = i;
            return;
        }
        this.current_it_idx = -1;
    }

    @Override
    public void moveToNextNvc() {
        LowLevelIterator it = this.nonEmptyIterators[this.current_it_idx];
        it.moveToNextNvc();
        if (it.isValid()) {
            return;
        }
        int nbrIt = this.nonEmptyIterators.length;
        for (int i = this.current_it_idx + 1; i < nbrIt; ++i) {
            it = this.nonEmptyIterators[i];
            it.moveToFirst();
            if (!it.isValid()) continue;
            this.current_it_idx = i;
            return;
        }
        this.current_it_idx = -1;
    }

    @Override
    public void moveToPreviousNvc() {
        LowLevelIterator it = this.nonEmptyIterators[this.current_it_idx];
        it.moveToPreviousNvc();
        if (it.isValid()) {
            return;
        }
        for (int i = this.current_it_idx - 1; i >= 0; --i) {
            it = this.nonEmptyIterators[i];
            it.moveToLastNoReinit();
            if (!it.isValid()) continue;
            this.current_it_idx = i;
            return;
        }
        this.current_it_idx = -1;
    }

    @Override
    public int ll_indexSizeMaybeNotCurrent() {
        int sum = 0;
        for (int i = this.nonEmptyIterators.length - 1; i >= 0; --i) {
            LowLevelIterator it = this.nonEmptyIterators[i];
            sum += it.ll_indexSizeMaybeNotCurrent();
        }
        return sum;
    }

    @Override
    public int ll_maxAnnotSpan() {
        throw Misc.internalError();
    }

    @Override
    public FsIterator_aggregation_common<T> copy() {
        return new FsIterator_aggregation_common<T>(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(":").append(System.identityHashCode(this));
        if (this.nonEmptyIterators.length == 0) {
            sb.append(" empty iterator");
            return sb.toString();
        }
        sb.append(this.main_idx == null && this.nonEmptyIterators.length > 1 ? " over multiple Types: " : " over type: ");
        if (this.main_idx == null) {
            if (this.nonEmptyIterators.length > 1) {
                sb.append('[');
                for (LowLevelIterator it : this.nonEmptyIterators) {
                    Type type = it.ll_getIndex().getType();
                    sb.append(type.getName()).append(':').append(((TypeImpl)type).getCode()).append(' ');
                }
                sb.append(']');
            } else {
                Type type = this.nonEmptyIterators[0].ll_getIndex().getType();
                sb.append(type.getName()).append(':').append(((TypeImpl)type).getCode()).append(' ');
            }
        } else {
            Type type = this.main_idx.getType();
            sb.append(type.getName()).append(':').append(((TypeImpl)type).getCode()).append(' ');
        }
        sb.append(", iterator size (may not match current index size): ").append(this.ll_indexSizeMaybeNotCurrent());
        return sb.toString();
    }

    @Override
    public Comparator<TOP> getComparator() {
        return null;
    }
}

