/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jabsorb.localarg.LocalArgController;
import org.jabsorb.reflect.AccessibleObjectKey;
import org.jabsorb.reflect.ClassData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(ClassAnalyzer.class);
    private static Map classCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassData getClassData(Class clazz) {
        ClassData cd;
        Map map = classCache;
        synchronized (map) {
            cd = (ClassData)classCache.get(clazz);
            if (cd == null) {
                cd = ClassAnalyzer.analyzeClass(clazz);
                classCache.put(clazz, cd);
            }
        }
        return cd;
    }

    public static void invalidateCache() {
        classCache = new HashMap();
    }

    private static ClassData analyzeClass(Class clazz) {
        log.info("analyzing " + clazz.getName());
        ArrayList constructors = new ArrayList(Arrays.asList(clazz.getConstructors()));
        ArrayList<Method> memberMethods = new ArrayList<Method>();
        ArrayList<Method> staticMethods = new ArrayList<Method>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (Modifier.isStatic(methods[i].getModifiers())) {
                staticMethods.add(methods[i]);
                continue;
            }
            memberMethods.add(methods[i]);
        }
        ClassData cd = new ClassData(clazz, ClassAnalyzer.createMap(memberMethods, false), ClassAnalyzer.createMap(staticMethods, false), ClassAnalyzer.createMap(constructors, true));
        return cd;
    }

    private static Map createMap(Collection accessibleObjects, boolean isConstructor) {
        HashMap<AccessibleObjectKey, ArrayList<Member>> map = new HashMap<AccessibleObjectKey, ArrayList<Member>>();
        for (Member accessibleObject : accessibleObjects) {
            Class<?>[] param;
            if (!Modifier.isPublic(accessibleObject.getModifiers())) continue;
            int argCount = 0;
            if (isConstructor) {
                param = ((Constructor)accessibleObject).getParameterTypes();
            } else {
                if (((Method)accessibleObject).getDeclaringClass() == Object.class) continue;
                param = ((Method)accessibleObject).getParameterTypes();
            }
            for (int n = 0; n < param.length; ++n) {
                if (LocalArgController.isLocalArg(param[n])) continue;
                ++argCount;
            }
            AccessibleObjectKey accessibleObjectKey = isConstructor ? new AccessibleObjectKey("$constructor", argCount) : new AccessibleObjectKey(((Method)accessibleObject).getName(), argCount);
            ArrayList<Member> marr = (ArrayList<Member>)map.get(accessibleObjectKey);
            if (marr == null) {
                marr = new ArrayList<Member>();
                map.put(accessibleObjectKey, marr);
            }
            marr.add(accessibleObject);
        }
        return map;
    }
}

