/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.FetchSessionCache;
import kafka.server.FetchSessionCacheShard;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0005\u000b\u0001=A\u0001\u0002\b\u0001\u0003\u0006\u0004%I!\b\u0005\tU\u0001\u0011\t\u0011)A\u0005=!A1\u0006\u0001BC\u0002\u0013%A\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u0015\u0011\u0004\u0001\"\u00018\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015\t\b\u0001\"\u0003s\u000511U\r^2i\u001b\u0006t\u0017mZ3s\u0015\tYA\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0007\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"a\u0002'pO\u001eLgnZ\u0001\u0005i&lW-F\u0001\u001f!\ty\u0002&D\u0001!\u0015\tI\u0012E\u0003\u0002#G\u000511m\\7n_:T!!\u0004\u0013\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\u0005\u0003S\u0001\u0012A\u0001V5nK\u0006)A/[7fA\u0005)1-Y2iKV\tQ\u0006\u0005\u0002/_5\t!\"\u0003\u00021\u0015\t\tb)\u001a;dQN+7o]5p]\u000e\u000b7\r[3\u0002\r\r\f7\r[3!\u0003\u0019a\u0014N\\5u}Q\u0019A'\u000e\u001c\u0011\u00059\u0002\u0001\"\u0002\u000f\u0006\u0001\u0004q\u0002\"B\u0016\u0006\u0001\u0004iCc\u0001\u001b9s!)AD\u0002a\u0001=!)!H\u0002a\u0001w\u0005Q1-Y2iKNC\u0017M\u001d3\u0011\u00059b\u0014BA\u001f\u000b\u0005Y1U\r^2i'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.Z*iCJ$\u0017A\u00038fo\u000e{g\u000e^3yiR9\u0001i\u0011%Q+zc\u0007C\u0001\u0018B\u0013\t\u0011%B\u0001\u0007GKR\u001c\u0007nQ8oi\u0016DH\u000fC\u0003E\u000f\u0001\u0007Q)\u0001\u0006sKF4VM]:j_:\u0004\"!\u0005$\n\u0005\u001d\u0013\"!B*i_J$\b\"B%\b\u0001\u0004Q\u0015a\u0003:fc6+G/\u00193bi\u0006\u0004\"a\u0013(\u000e\u00031S!!T\u0011\u0002\u0011I,\u0017/^3tiNL!a\u0014'\u0003\u001b\u0019+Go\u00195NKR\fG-\u0019;b\u0011\u0015\tv\u00011\u0001S\u0003)I7OR8mY><XM\u001d\t\u0003#MK!\u0001\u0016\n\u0003\u000f\t{w\u000e\\3b]\")ak\u0002a\u0001/\u0006Ia-\u001a;dQ\u0012\u000bG/\u0019\t\u00031ns!AL-\n\u0005iS\u0011\u0001\u0004$fi\u000eD7+Z:tS>t\u0017B\u0001/^\u0005\u001d\u0011V)U0N\u0003BS!A\u0017\u0006\t\u000b};\u0001\u0019\u00011\u0002\u0011Q|gi\u001c:hKR\u00042!\u00194i\u001b\u0005\u0011'BA2e\u0003\u0011)H/\u001b7\u000b\u0003\u0015\fAA[1wC&\u0011qM\u0019\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002jU6\t\u0011%\u0003\u0002lC\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\u0006[\u001e\u0001\rA\\\u0001\u000bi>\u0004\u0018n\u0019(b[\u0016\u001c\bC\u0001-p\u0013\t\u0001XL\u0001\bU\u001fBK5i\u0018(B\u001b\u0016{V*\u0011)\u0002+A\f'\u000f^5uS>t7\u000fV8M_\u001e\u001cFO]5oOR\u00111O \t\u0003int!!^=\u0011\u0005Y\u0014R\"A<\u000b\u0005at\u0011A\u0002\u001fs_>$h(\u0003\u0002{%\u00051\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQ(\u0003\u0003\u0004\u0000\u0011\u0001\u0007\u0011\u0011A\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003B1\u0002\u0004!L1!!\u0002c\u0005)\u0019u\u000e\u001c7fGRLwN\u001c")
public class FetchManager
implements Logging {
    private final Time time;
    private final FetchSessionCache cache;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    /*
     * WARNING - void declaration
     */
    public FetchContext newContext(short reqVersion, FetchMetadata reqMetadata, boolean isFollower, Map<TopicIdPartition, FetchRequest.PartitionData> fetchData, java.util.List<TopicIdPartition> toForget, Map<Uuid, String> topicNames) {
        if (reqMetadata.isFull()) {
            FetchContext fetchContext;
            ObjectRef removedFetchSessionStr = ObjectRef.create((Object)"");
            if (reqMetadata.sessionId() != 0 && this.cache().getCacheShard(reqMetadata.sessionId()).remove(reqMetadata.sessionId()).isDefined()) {
                removedFetchSessionStr.elem = new StringBuilder(24).append(" Removed fetch session ").append(reqMetadata.sessionId()).append(".").toString();
            }
            ObjectRef suffix = ObjectRef.create((Object)"");
            if (reqMetadata.epoch() == -1) {
                suffix.elem = " Will not try to create a new session.";
                fetchContext = new SessionlessFetchContext(fetchData);
            } else {
                fetchContext = new FullFetchContext(this.time(), this.cache(), reqMetadata, fetchData, reqVersion >= 13, isFollower);
            }
            FetchContext context = fetchContext;
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Created a new full FetchContext with ").append(this.partitionsToLogString(fetchData.keySet())).append(".").append((String)removedFetchSessionStr$1.elem).append((String)suffix$1.elem).toString());
            return context;
        }
        FetchSessionCacheShard cacheShard = this.cache().getCacheShard(reqMetadata.sessionId());
        synchronized (cacheShard) {
            SessionErrorContext sessionErrorContext;
            Option<FetchSession> option = cacheShard.get(reqMetadata.sessionId());
            if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Session error for ").append(reqMetadata.sessionId()).append(": no such session ID found.").toString());
                sessionErrorContext = new SessionErrorContext(Errors.FETCH_SESSION_ID_NOT_FOUND, reqMetadata);
            } else if (option instanceof Some) {
                FetchSession session = (FetchSession)((Some)option).value();
                synchronized (session) {
                    FetchContext fetchContext;
                    if (session.epoch() != reqMetadata.epoch()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Session error for ").append(reqMetadata.sessionId()).append(": expected epoch ").append(session.epoch()).append(", but got ").append(reqMetadata.epoch()).append(" instead.").toString());
                        fetchContext = new SessionErrorContext(Errors.INVALID_FETCH_SESSION_EPOCH, reqMetadata);
                    } else if (session.usesTopicIds() && reqVersion < 13 || !session.usesTopicIds() && reqVersion >= 13) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Session error for ").append(reqMetadata.sessionId()).append(": expected  ").append((Object)(session.usesTopicIds() ? "to use topic IDs" : "to not use topic IDs")).append(", but request version ").append(reqVersion).append(" means that we can not.").toString());
                        fetchContext = new SessionErrorContext(Errors.FETCH_SESSION_TOPIC_ID_ERROR, reqMetadata);
                    } else {
                        void var18_16;
                        Tuple3<ArrayList<TopicIdPartition>, ArrayList<TopicIdPartition>, ArrayList<TopicIdPartition>> tuple3 = session.update(fetchData, toForget, reqMetadata);
                        if (tuple3 == null) {
                            throw new MatchError(null);
                        }
                        ArrayList added = (ArrayList)tuple3._1();
                        ArrayList updated = (ArrayList)tuple3._2();
                        ArrayList removed = (ArrayList)tuple3._3();
                        if (session.isEmpty()) {
                            this.debug((Function0<String>)((Function0 & Serializable)() -> FetchManager.$anonfun$newContext$5(this, session, (ArrayList)var18_16)));
                            cacheShard.remove(session);
                            fetchContext = new SessionlessFetchContext(fetchData);
                        } else {
                            void var17_15;
                            void var16_14;
                            cacheShard.touch(session, this.time().milliseconds());
                            session.epoch_$eq(FetchMetadata.nextEpoch((int)session.epoch()));
                            this.debug((Function0<String>)((Function0 & Serializable)() -> FetchManager.$anonfun$newContext$6(this, session, (ArrayList)var16_14, (ArrayList)var17_15, (ArrayList)var18_16)));
                            fetchContext = new IncrementalFetchContext(this.time(), reqMetadata, session, topicNames);
                        }
                    }
                    SessionErrorContext sessionErrorContext2 = fetchContext;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 14, 15] lbl51 : MonitorExitStatement: MONITOREXIT : session
                    sessionErrorContext = sessionErrorContext2;
                }
            } else {
                throw new MatchError(option);
            }
            SessionErrorContext sessionErrorContext3 = sessionErrorContext;
            return sessionErrorContext3;
        }
    }

    private String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchSession$.MODULE$.partitionsToLogString(partitions, this.isTraceEnabled());
    }

    public static final /* synthetic */ String $anonfun$newContext$5(FetchManager $this, FetchSession session$3, ArrayList removed$2) {
        return new StringBuilder(123).append("Created a new sessionless FetchContext and closing session id ").append(session$3.id()).append(", ").append("epoch ").append(session$3.epoch()).append(": after removing ").append($this.partitionsToLogString(removed$2)).append(", ").append("there are no more partitions left.").toString();
    }

    public static final /* synthetic */ String $anonfun$newContext$6(FetchManager $this, FetchSession session$3, ArrayList added$2, ArrayList updated$2, ArrayList removed$2) {
        return new StringBuilder(90).append("Created a new incremental FetchContext for session id ").append(session$3.id()).append(", ").append("epoch ").append(session$3.epoch()).append(": added ").append($this.partitionsToLogString(added$2)).append(", ").append("updated ").append($this.partitionsToLogString(updated$2)).append(", ").append("removed ").append($this.partitionsToLogString(removed$2)).toString();
    }

    public FetchManager(Time time, FetchSessionCache cache) {
        this.time = time;
        this.cache = cache;
    }

    public FetchManager(Time time, FetchSessionCacheShard cacheShard) {
        this(time, new FetchSessionCache((Seq<FetchSessionCacheShard>)new .colon.colon((Object)cacheShard, (List)Nil$.MODULE$)));
    }
}

