/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.behavior;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;

public class AttributeAppender
extends AttributeModifier {
    private static final long serialVersionUID = 1L;
    private String separator;

    public AttributeAppender(String attribute, IModel<?> replaceModel) {
        super(attribute, replaceModel);
    }

    public AttributeAppender(String attribute, Serializable value) {
        super(attribute, value);
    }

    public AttributeAppender(String attribute, Serializable value, String separator) {
        super(attribute, value);
        this.setSeparator(separator);
    }

    public AttributeAppender(String attribute, IModel<?> appendModel, String separator) {
        super(attribute, appendModel);
        this.setSeparator(separator);
    }

    public String getSeparator() {
        return this.separator;
    }

    public AttributeAppender setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    protected Serializable newValue(String currentValue, String appendValue) {
        if (Strings.isEmpty((String)currentValue)) {
            return appendValue;
        }
        if (Strings.isEmpty((String)appendValue)) {
            return currentValue;
        }
        StringBuilder sb = new StringBuilder(currentValue);
        sb.append(this.getSeparator() == null ? "" : this.getSeparator());
        sb.append(appendValue);
        return sb.toString();
    }

    @Override
    public String toString() {
        Object attributeModifier = super.toString();
        attributeModifier = ((String)attributeModifier).substring(0, ((String)attributeModifier).length() - 2) + ", separator=" + this.separator + "]";
        return attributeModifier;
    }
}

