/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import com.nimbusds.jwt.JWTClaimsSet;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.OAuth20TokenExchangeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthTokenExchangePolicy;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenTokenExchangeGrantRequestExtractor
extends BaseAccessTokenGrantRequestExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenTokenExchangeGrantRequestExtractor.class);

    public AccessTokenTokenExchangeGrantRequestExtractor(OAuth20ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    public boolean supports(WebContext context) {
        String grantType = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "grant_type").orElse("");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.TOKEN_EXCHANGE;
    }

    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.NONE;
    }

    @Override
    protected AccessTokenRequestContext extractRequest(WebContext webContext) throws Throwable {
        OAuth20RequestParameterResolver requestParameterResolver = this.getConfigurationContext().getRequestParameterResolver();
        Set scopes = requestParameterResolver.resolveRequestScopes(webContext);
        String requestedTokenType = requestParameterResolver.resolveRequestParameter(webContext, "requested_token_type").orElseGet(() -> ((OAuth20TokenExchangeTypes)OAuth20TokenExchangeTypes.ACCESS_TOKEN).getType());
        OAuth20TokenExchangeTypes subjectTokenType = requestParameterResolver.resolveRequestParameter(webContext, "subject_token_type").map(OAuth20TokenExchangeTypes::from).orElseThrow(() -> new IllegalArgumentException("Subject token type cannot be undefined"));
        String subjectToken = (String)requestParameterResolver.resolveRequestParameter(webContext, "subject_token").orElseThrow(() -> new IllegalArgumentException("Subject token cannot be undefined"));
        Optional resource = requestParameterResolver.resolveRequestParameter(webContext, "resource");
        String audience = requestParameterResolver.resolveRequestParameter(webContext, "audience").orElse(null);
        ExtractedRequest extractedRequest = switch (subjectTokenType) {
            case OAuth20TokenExchangeTypes.ACCESS_TOKEN -> {
                OAuth20AccessToken token = (OAuth20AccessToken)this.getConfigurationContext().getTicketRegistry().getTicket(subjectToken, OAuth20AccessToken.class);
                OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), token.getClientId());
                yield new ExtractedRequest((Serializable)token, token.getService(), registeredService, token.getAuthentication());
            }
            case OAuth20TokenExchangeTypes.JWT -> {
                JWTClaimsSet claimSet = this.getConfigurationContext().getAccessTokenJwtBuilder().unpack(Optional.empty(), subjectToken);
                WebApplicationService service = (WebApplicationService)this.getConfigurationContext().getWebApplicationServiceServiceFactory().createService(claimSet.getIssuer());
                service.getAttributes().put("client_id", List.of(claimSet.getIssuer()));
                OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), claimSet.getIssuer());
                UserProfile userProfile = this.extractUserProfile(webContext).orElseThrow();
                Authentication authentication = this.getConfigurationContext().getAuthenticationBuilder().build(userProfile, registeredService, webContext, (Service)service);
                yield new ExtractedRequest((Serializable)claimSet, (Service)service, registeredService, authentication);
            }
            default -> throw new IllegalArgumentException("Subject token type %s is not supported".formatted(subjectTokenType));
        };
        WebApplicationService resourceService = resource.map(res -> {
            WebApplicationService service = (WebApplicationService)this.getConfigurationContext().getWebApplicationServiceServiceFactory().createService(res);
            service.getAttributes().put("client_id", List.of(extractedRequest.registeredService().getClientId()));
            return service;
        }).orElse(null);
        return AccessTokenRequestContext.builder().scopes(scopes).grantType(this.getGrantType()).subjectTokenType(subjectTokenType).requestedTokenType(OAuth20TokenExchangeTypes.from((String)requestedTokenType)).subjectToken(extractedRequest.token()).tokenExchangeResource((Service)resourceService).tokenExchangeAudience(audience).service(extractedRequest.service()).registeredService(extractedRequest.registeredService()).authentication(extractedRequest.authentication()).actorToken(this.getActorTokenAuthentication(webContext, extractedRequest)).build();
    }

    protected Authentication getActorTokenAuthentication(WebContext webContext, ExtractedRequest extractedRequest) throws Throwable {
        Optional actorToken = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(webContext, "actor_token");
        Optional<OAuth20TokenExchangeTypes> actorTokenType = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(webContext, "actor_token_type").map(OAuth20TokenExchangeTypes::from);
        FunctionUtils.throwIf((actorToken.isPresent() && actorTokenType.isEmpty() ? 1 : 0) != 0, () -> new IllegalArgumentException("Actor token type cannot be undefined when actor token is provided"));
        if (actorToken.isPresent()) {
            RegisteredServiceOAuthTokenExchangePolicy tokenExchangePolicy;
            Authentication actorAuthentication = switch (actorTokenType.get()) {
                case OAuth20TokenExchangeTypes.ACCESS_TOKEN -> {
                    OAuth20Token token = (OAuth20Token)this.getConfigurationContext().getTicketRegistry().getTicket((String)actorToken.get(), OAuth20Token.class);
                    yield token.getAuthentication();
                }
                case OAuth20TokenExchangeTypes.JWT -> {
                    JWTClaimsSet claimSet = this.getConfigurationContext().getAccessTokenJwtBuilder().unpack(Optional.empty(), (String)actorToken.get());
                    WebApplicationService service = (WebApplicationService)this.getConfigurationContext().getWebApplicationServiceServiceFactory().createService(claimSet.getIssuer());
                    service.getAttributes().put("client_id", List.of(claimSet.getIssuer()));
                    OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), claimSet.getIssuer());
                    UserProfile userProfile = this.extractUserProfile(webContext).orElseThrow();
                    yield this.getConfigurationContext().getAuthenticationBuilder().build(userProfile, registeredService, webContext, (Service)service);
                }
                default -> throw new IllegalArgumentException("Actor token type %s is not supported".formatted(actorTokenType.get()));
            };
            RegisteredServiceOAuthTokenExchangePolicy registeredServiceOAuthTokenExchangePolicy = tokenExchangePolicy = extractedRequest.registeredService() != null ? extractedRequest.registeredService().getTokenExchangePolicy() : null;
            if (tokenExchangePolicy == null || tokenExchangePolicy.canSubjectTokenActAs(extractedRequest.authentication(), actorAuthentication, (String)actorTokenType.map(OAuth20TokenExchangeTypes::getType).orElse(null))) {
                return actorAuthentication;
            }
        }
        return null;
    }

    private record ExtractedRequest(Serializable token, Service service, OAuthRegisteredService registeredService, Authentication authentication) {
    }
}

