/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.replication.SessionReplicationProperties;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public abstract class BaseOAuth20Controller<T extends OAuth20ConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOAuth20Controller.class);
    protected final T configurationContext;

    protected OAuth20AccessToken resolveAccessToken(Ticket givenAccessToken) {
        return this.resolveToken(givenAccessToken, OAuth20AccessToken.class);
    }

    protected <U extends Ticket> U resolveToken(Ticket token, Class<U> clazz) {
        return (U)(token.isStateless() ? ((OAuth20ConfigurationContext)this.configurationContext).getTicketRegistry().getTicket(token.getId(), clazz) : (Ticket)clazz.cast(token));
    }

    protected String extractAccessTokenFrom(String token) {
        return (String)OAuth20JwtAccessTokenEncoder.toDecodableCipher(((OAuth20ConfigurationContext)this.getConfigurationContext()).getAccessTokenJwtBuilder()).decode((Object)token);
    }

    protected void ensureSessionReplicationIsAutoconfiguredIfNeedBe(HttpServletRequest request) {
        SessionReplicationProperties replicationProps = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getPac4j().getCore().getSessionReplication();
        boolean cookieAutoconfigured = replicationProps.getCookie().isAutoConfigureCookiePath();
        if (replicationProps.isReplicateSessions() && cookieAutoconfigured) {
            String contextPath = request.getContextPath();
            Object cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + "/" : "/";
            String path = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthDistributedSessionCookieGenerator().getCookiePath();
            if (StringUtils.isBlank((CharSequence)path)) {
                LOGGER.debug("Setting path for cookies for OAuth distributed session cookie generator to: [{}]", cookiePath);
                ((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthDistributedSessionCookieGenerator().setCookiePath((String)cookiePath);
            } else {
                LOGGER.trace("OAuth distributed cookie domain is [{}] with path [{}]", (Object)((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthDistributedSessionCookieGenerator().getCookieDomain(), (Object)path);
            }
        }
    }

    protected boolean isRequestAuthenticated(ProfileManager manager, WebContext context, OAuthRegisteredService registeredService) {
        return manager.getProfile().isPresent();
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthServiceByClientId(((OAuth20ConfigurationContext)this.getConfigurationContext()).getServicesManager(), clientId);
    }

    protected static boolean isRefreshToken(OAuth20Token token) {
        return token instanceof OAuth20RefreshToken;
    }

    protected static boolean isAccessToken(OAuth20Token token) {
        return token instanceof OAuth20AccessToken;
    }

    protected void revokeToken(OAuth20RefreshToken token) throws Exception {
        this.revokeToken(token.getId());
        token.getAccessTokens().forEach(Unchecked.consumer(this::revokeToken));
    }

    protected void revokeToken(String token) throws Exception {
        LOGGER.debug("Revoking token [{}]", (Object)token);
        ((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().deleteTicket(token);
    }

    @Generated
    protected BaseOAuth20Controller(T configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public T getConfigurationContext() {
        return this.configurationContext;
    }
}

