/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.http.url.UrlResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20CasCallbackUrlResolver
implements UrlResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20CasCallbackUrlResolver.class);
    private final String callbackUrl;
    private final OAuth20RequestParameterResolver requestParameterResolver;

    public String compute(String url, WebContext context) {
        if (!url.startsWith(this.callbackUrl)) {
            return url;
        }
        return (String)FunctionUtils.doUnchecked(() -> {
            URIBuilder builder = new URIBuilder(url);
            List<String> includeParameterNames = this.getIncludeParameterNames();
            includeParameterNames.forEach(param -> this.addUrlParameter(context, builder, (String)param));
            HashMap existingParameters = new HashMap(context.getRequestParameters());
            includeParameterNames.forEach(existingParameters.keySet()::remove);
            existingParameters.keySet().removeAll(OAuth20CasCallbackUrlResolver.getExcludedParameterNames());
            existingParameters.entrySet().stream().filter(entry -> ((String[])entry.getValue()).length > 0).forEach(entry -> builder.addParameter((String)entry.getKey(), ((String[])entry.getValue())[0]));
            String callbackResolved = builder.build().toString();
            LOGGER.debug("Final resolved callback URL is [{}]", (Object)callbackResolved);
            return callbackResolved;
        });
    }

    private static Collection<String> getExcludedParameterNames() {
        return List.of("service", "targetService", "ticket");
    }

    protected List<String> getIncludeParameterNames() {
        return CollectionUtils.wrapList((Object[])new String[]{"client_id", "scope", "redirect_uri", "acr_values", "response_type", "grant_type", "response_mode", "claims", "request", "state", "nonce", "token"});
    }

    private Optional<NameValuePair> getQueryParameter(WebContext context, String name) {
        Optional<String> value = this.requestParameterResolver.resolveRequestParameter(context, name).or(Unchecked.supplier(() -> {
            URIBuilder builderContext = new URIBuilder(context.getFullRequestURL());
            return builderContext.getQueryParams().stream().filter(p -> p.getName().equalsIgnoreCase(name)).map(NameValuePair::getValue).findFirst();
        }));
        return value.map(v -> new BasicNameValuePair(name, v));
    }

    private void addUrlParameter(WebContext context, URIBuilder builder, String parameterName) {
        Optional<NameValuePair> parameter = this.getQueryParameter(context, parameterName);
        parameter.ifPresent(basicNameValuePair -> builder.addParameter(basicNameValuePair.getName(), basicNameValuePair.getValue()));
    }

    @Generated
    public OAuth20CasCallbackUrlResolver(String callbackUrl, OAuth20RequestParameterResolver requestParameterResolver) {
        this.callbackUrl = callbackUrl;
        this.requestParameterResolver = requestParameterResolver;
    }
}

