/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.QueryParam;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.rest.api.beans.AbstractTimeframeQuery;

public class AuditQuery
extends AbstractTimeframeQuery {
    private static final long serialVersionUID = -2863334226169614417L;
    private String entityKey;
    private OpEvent.CategoryType type;
    private String category;
    private String subcategory;
    private String op;
    private OpEvent.Outcome outcome;

    @Parameter(name="entityKey", description="audit entity key to match", schema=@Schema(implementation=String.class, example="50592942-73ec-44c4-a377-e859524245e4"))
    public String getEntityKey() {
        return this.entityKey;
    }

    @QueryParam(value="entityKey")
    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    @Parameter(name="type", description="audit type to match", schema=@Schema(implementation=OpEvent.CategoryType.class))
    public OpEvent.CategoryType getType() {
        return this.type;
    }

    @QueryParam(value="type")
    public void setType(OpEvent.CategoryType type) {
        this.type = type;
    }

    @Parameter(name="category", description="audit category to match", schema=@Schema(implementation=String.class))
    public String getCategory() {
        return this.category;
    }

    @QueryParam(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @Parameter(name="subcategory", description="audit subcategory to match", schema=@Schema(implementation=String.class))
    public String getSubcategory() {
        return this.subcategory;
    }

    @QueryParam(value="subcategory")
    public void setSubcategory(String subcategory) {
        this.subcategory = subcategory;
    }

    @Parameter(name="outcome", description="audit event outcome to match", schema=@Schema(implementation=OpEvent.Outcome.class))
    public OpEvent.Outcome getOutcome() {
        return this.outcome;
    }

    @QueryParam(value="outcome")
    public void setOutcome(OpEvent.Outcome outcome) {
        this.outcome = outcome;
    }

    @Parameter(name="op", description="audit event op to match", schema=@Schema(implementation=String.class))
    public String getOp() {
        return this.op;
    }

    @QueryParam(value="op")
    public void setOp(String op) {
        this.op = op;
    }

    public static class Builder
    extends AbstractTimeframeQuery.Builder<AuditQuery, Builder> {
        @Override
        protected AuditQuery newInstance() {
            return new AuditQuery();
        }

        public Builder entityKey(String entityKey) {
            ((AuditQuery)this.getInstance()).setEntityKey(entityKey);
            return this;
        }

        public Builder type(OpEvent.CategoryType type) {
            ((AuditQuery)this.getInstance()).setType(type);
            return this;
        }

        public Builder category(String category) {
            ((AuditQuery)this.getInstance()).setCategory(category);
            return this;
        }

        public Builder subcategory(String subcategory) {
            ((AuditQuery)this.getInstance()).setSubcategory(subcategory);
            return this;
        }

        public Builder op(String op) {
            ((AuditQuery)this.getInstance()).setOp(op);
            return this;
        }

        public Builder outcome(OpEvent.Outcome outcome) {
            ((AuditQuery)this.getInstance()).setOutcome(outcome);
            return this;
        }
    }
}

