/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.security.Key;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.util.cipher.BaseStringCipherExecutor;
import org.apereo.cas.util.cipher.BasicIdentifiableKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOidcJwtCipherExecutor
extends BaseStringCipherExecutor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOidcJwtCipherExecutor.class);
    protected final LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> defaultJsonWebKeystoreCache;
    protected final OidcIssuerService oidcIssuerService;

    public boolean isEnabled() {
        boolean signing = this.isSigningEnabled() && this.getJsonWebKeyFor(OidcJsonWebKeyUsage.SIGNING).findAny().isPresent();
        boolean enc = this.isEncryptionEnabled() && this.getJsonWebKeyFor(OidcJsonWebKeyUsage.ENCRYPTION).findAny().isPresent();
        return signing || enc;
    }

    public String encode(Serializable value, Object[] parameters) {
        this.prepareKeysForSigningAndEncryption();
        return super.encode(value, parameters);
    }

    private void prepareKeysForSigningAndEncryption() {
        this.getJsonWebKeyFor(OidcJsonWebKeyUsage.SIGNING).map(jwks -> (JsonWebKey)jwks.getJsonWebKeys().getFirst()).map(PublicJsonWebKey.class::cast).findAny().ifPresent(key -> this.setSigningKey((Key)new BasicIdentifiableKey(key.getKeyId(), (Key)key.getPrivateKey())));
        this.getJsonWebKeyFor(OidcJsonWebKeyUsage.ENCRYPTION).map(jwks -> (JsonWebKey)jwks.getJsonWebKeys().getFirst()).findAny().ifPresent(key -> {
            this.setEncryptionKey((Key)new BasicIdentifiableKey(key.getKeyId(), key.getKey()));
            this.configureEncryptionSettingsFor((JsonWebKey)key);
        });
    }

    protected void configureEncryptionSettingsFor(JsonWebKey key) {
        this.setContentEncryptionAlgorithmIdentifier("A128CBC-HS256");
        this.setEncryptionAlgorithm("RSA-OAEP-256");
    }

    public String decode(Serializable value, Object[] parameters) {
        this.prepareKeysForDecryptionAndVerification();
        return super.decode(value, parameters);
    }

    private void prepareKeysForDecryptionAndVerification() {
        this.getJsonWebKeyFor(OidcJsonWebKeyUsage.ENCRYPTION).map(jwks -> (JsonWebKey)jwks.getJsonWebKeys().getFirst()).map(PublicJsonWebKey.class::cast).findAny().ifPresent(key -> {
            this.setEncryptionKey((Key)new BasicIdentifiableKey(key.getKeyId(), (Key)key.getPrivateKey()));
            this.configureEncryptionSettingsFor((JsonWebKey)key);
        });
        this.getJsonWebKeyFor(OidcJsonWebKeyUsage.SIGNING).map(jwks -> (JsonWebKey)jwks.getJsonWebKeys().getFirst()).map(PublicJsonWebKey.class::cast).findAny().ifPresent(key -> this.setSigningKey((Key)new BasicIdentifiableKey(key.getKeyId(), key.getKey())));
    }

    private Stream<JsonWebKeySet> getJsonWebKeyFor(OidcJsonWebKeyUsage usage) {
        String issuer = this.oidcIssuerService.determineIssuer(Optional.empty());
        LOGGER.trace("Determined issuer [{}] to fetch the JSON web key", (Object)issuer);
        return Stream.of((JsonWebKeySet)this.defaultJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(issuer, usage)));
    }

    @Generated
    public LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> getDefaultJsonWebKeystoreCache() {
        return this.defaultJsonWebKeystoreCache;
    }

    @Generated
    public OidcIssuerService getOidcIssuerService() {
        return this.oidcIssuerService;
    }

    @Generated
    public BaseOidcJwtCipherExecutor(LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> defaultJsonWebKeystoreCache, OidcIssuerService oidcIssuerService) {
        this.defaultJsonWebKeystoreCache = defaultJsonWebKeystoreCache;
        this.oidcIssuerService = oidcIssuerService;
    }
}

