/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.slo;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apereo.cas.logout.slo.SingleLogoutMessage;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.DigestUtils;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class OidcSingleLogoutMessageCreator
implements SingleLogoutMessageCreator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcSingleLogoutMessageCreator.class);
    private final ObjectProvider<OidcConfigurationContext> configurationProvider;

    public SingleLogoutMessage create(SingleLogoutRequestContext request) throws Throwable {
        OidcConfigurationContext configurationContext = (OidcConfigurationContext)((Object)this.configurationProvider.getObject());
        SingleLogoutMessage.SingleLogoutMessageBuilder builder = SingleLogoutMessage.builder();
        if (request.getLogoutType() == RegisteredServiceLogoutType.BACK_CHANNEL) {
            LOGGER.trace("Building logout token for [{}]", (Object)request.getRegisteredService());
            JwtClaims claims = this.buildJwtClaims(request);
            String logoutToken = configurationContext.getIdTokenSigningAndEncryptionService().encode((OAuthRegisteredService)request.getRegisteredService(), claims);
            return builder.payload(logoutToken).build();
        }
        return builder.payload("").build();
    }

    protected JwtClaims buildJwtClaims(SingleLogoutRequestContext request) {
        OidcConfigurationContext configurationContext = (OidcConfigurationContext)((Object)this.configurationProvider.getObject());
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(configurationContext.getIssuerService().determineIssuer(Optional.empty()));
        claims.setSubject(request.getExecutionRequest().getTicketGrantingTicket().getAuthentication().getPrincipal().getId());
        claims.setAudience(((OAuthRegisteredService)request.getRegisteredService()).getClientId());
        claims.setIssuedAtToNow();
        claims.setJwtId(UUID.randomUUID().toString());
        claims.setExpirationTimeMinutesInTheFuture(1.0f);
        HashMap events = new HashMap();
        events.put("http://schemas.openid.net/event/backchannel-logout", new HashMap());
        claims.setClaim("events", events);
        claims.setClaim("sid", (Object)DigestUtils.sha((String)DigestUtils.sha512((String)request.getExecutionRequest().getTicketGrantingTicket().getId())));
        return claims;
    }

    @Generated
    public OidcSingleLogoutMessageCreator(ObjectProvider<OidcConfigurationContext> configurationProvider) {
        this.configurationProvider = configurationProvider;
    }
}

