/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.Set;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;

public class SequentialMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    private static final long serialVersionUID = 1L;

    public SequentialMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        super(activity, innerActivityBehavior);
    }

    @Override
    protected int createInstances(DelegateExecution multiInstanceRootExecution) {
        int nrOfInstances = this.resolveNrOfInstances(multiInstanceRootExecution);
        if (nrOfInstances == 0) {
            return nrOfInstances;
        }
        if (nrOfInstances < 0) {
            throw new FlowableIllegalArgumentException("Invalid number of instances: must be a non-negative integer value, but was " + nrOfInstances);
        }
        ExecutionEntity execution = CommandContextUtil.getExecutionEntityManager().createChildExecution((ExecutionEntity)multiInstanceRootExecution);
        execution.setCurrentFlowElement(multiInstanceRootExecution.getCurrentFlowElement());
        this.setLoopVariable(multiInstanceRootExecution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(multiInstanceRootExecution, "nrOfActiveInstances", 1);
        this.logLoopDetails(multiInstanceRootExecution, "initialized", 0, 0, 1, nrOfInstances);
        this.executeOriginalBehavior(execution, (ExecutionEntity)multiInstanceRootExecution, 0);
        return nrOfInstances;
    }

    @Override
    public void leave(DelegateExecution execution) {
        DelegateExecution multiInstanceRootExecution = this.getMultiInstanceRootExecution(execution);
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable()) + 1;
        int nrOfInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfActiveInstances");
        this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        this.callActivityEndListeners(execution);
        this.aggregateVariablesForChildExecution(execution, multiInstanceRootExecution);
        boolean completeConditionSatisfied = this.completionConditionSatisfied(multiInstanceRootExecution);
        if (loopCounter >= nrOfInstances || completeConditionSatisfied) {
            if (completeConditionSatisfied) {
                this.sendCompletedWithConditionEvent(multiInstanceRootExecution);
            } else {
                this.sendCompletedEvent(multiInstanceRootExecution);
            }
            super.leave(execution);
        } else {
            this.continueSequentialMultiInstance(execution, loopCounter, (ExecutionEntity)multiInstanceRootExecution);
        }
    }

    public void continueSequentialMultiInstance(DelegateExecution execution, int loopCounter, ExecutionEntity multiInstanceRootExecution) {
        try {
            if (execution.getCurrentFlowElement() instanceof SubProcess) {
                ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
                ExecutionEntity executionToContinue = executionEntityManager.createChildExecution(multiInstanceRootExecution);
                executionToContinue.setCurrentFlowElement(execution.getCurrentFlowElement());
                executionToContinue.setScope(true);
                this.executeOriginalBehavior(executionToContinue, multiInstanceRootExecution, loopCounter);
            } else {
                CommandContextUtil.getActivityInstanceEntityManager().recordActivityEnd((ExecutionEntity)execution, null);
                Set localVariableInstances = execution.getVariableInstancesLocal().keySet();
                localVariableInstances.remove("nrOfInstances");
                localVariableInstances.remove("nrOfCompletedInstances");
                localVariableInstances.remove("nrOfActiveInstances");
                execution.removeVariablesLocal(localVariableInstances);
                this.executeOriginalBehavior(execution, multiInstanceRootExecution, loopCounter);
            }
        }
        catch (BpmnError error) {
            throw error;
        }
        catch (Exception e) {
            throw new FlowableException("Could not execute inner activity behavior of multi instance behavior for " + String.valueOf(execution), (Throwable)e);
        }
    }
}

