/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.support;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.AttributeIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractAttributeIndex<A, O>
implements AttributeIndex<A, O> {
    protected final Set<Class<? extends Query>> supportedQueries;
    protected final Attribute<O, A> attribute;

    protected AbstractAttributeIndex(Attribute<O, A> attribute, Set<Class<? extends Query>> supportedQueries) {
        this.attribute = attribute;
        this.supportedQueries = Collections.unmodifiableSet(supportedQueries);
    }

    @Override
    public Attribute<O, A> getAttribute() {
        return this.attribute;
    }

    @Override
    public boolean supportsQuery(Query<O> query, QueryOptions queryOptions) {
        return this.supportedQueries.contains(query.getClass());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAttributeIndex that = (AbstractAttributeIndex)o;
        return this.attribute.equals(that.attribute);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        result = 31 * result + this.attribute.hashCode();
        return result;
    }
}

