/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.brand;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.brand.Brand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultBrand
extends AbstractInstanceResource<Brand>
implements Brand {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final BooleanProperty agreeToCustomPrivacyPolicyProperty = new BooleanProperty("agreeToCustomPrivacyPolicy");
    private static final StringProperty customPrivacyPolicyUrlProperty = new StringProperty("customPrivacyPolicyUrl");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final BooleanProperty removePoweredByOktaProperty = new BooleanProperty("removePoweredByOkta");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultBrand.createPropertyDescriptorMap(linksProperty, agreeToCustomPrivacyPolicyProperty, customPrivacyPolicyUrlProperty, idProperty, removePoweredByOktaProperty);

    public DefaultBrand(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultBrand(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Brand.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Boolean getAgreeToCustomPrivacyPolicy() {
        return this.getBoolean(agreeToCustomPrivacyPolicyProperty);
    }

    public Brand setAgreeToCustomPrivacyPolicy(Boolean agreeToCustomPrivacyPolicy) {
        this.setProperty(agreeToCustomPrivacyPolicyProperty, (Object)agreeToCustomPrivacyPolicy);
        return this;
    }

    public String getCustomPrivacyPolicyUrl() {
        return this.getString(customPrivacyPolicyUrlProperty);
    }

    public Brand setCustomPrivacyPolicyUrl(String customPrivacyPolicyUrl) {
        this.setProperty(customPrivacyPolicyUrlProperty, (Object)customPrivacyPolicyUrl);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Boolean getRemovePoweredByOkta() {
        return this.getBoolean(removePoweredByOktaProperty);
    }

    public Brand setRemovePoweredByOkta(Boolean removePoweredByOkta) {
        this.setProperty(removePoweredByOktaProperty, (Object)removePoweredByOkta);
        return this;
    }

    public Brand update() {
        String brandId = this.getId();
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/brands/" + brandId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }
}

