/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback.mode;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth20ResponseModeFragmentBuilder
implements OAuth20ResponseModeBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ResponseModeFragmentBuilder.class);

    public OAuth20ResponseModeTypes getResponseMode() {
        return OAuth20ResponseModeTypes.FRAGMENT;
    }

    public ModelAndView build(RegisteredService registeredService, String redirectUrl, Map<String, String> parameters) throws Exception {
        URIBuilder urlBuilder = new URIBuilder(redirectUrl);
        List currentParams = urlBuilder.getQueryParams();
        urlBuilder.removeQuery();
        currentParams.removeIf(p -> parameters.containsKey(p.getName()));
        String fragment = parameters.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap(currentParams.size());
        currentParams.forEach(param -> queryParams.put((Object)param.getName(), List.of(param.getValue())));
        String resultUrl = UriComponentsBuilder.fromUriString((String)redirectUrl).fragment(fragment).queryParams((MultiValueMap)queryParams).build().toUriString();
        LOGGER.debug("Redirecting to [{}]", (Object)resultUrl);
        RedirectView mv = new RedirectView(resultUrl);
        return new ModelAndView((View)mv);
    }

    @Generated
    public OAuth20ResponseModeFragmentBuilder() {
    }
}

