/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.logging.MdcLoggingProperties;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.slf4j.MDC;
import org.springframework.beans.factory.ObjectProvider;

public class ThreadContextMDCServletFilter
implements Filter {
    private final ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    private final ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator;
    private final CasConfigurationProperties casProperties;

    private static void addContextAttribute(String attributeName, Object value) {
        String result = Optional.ofNullable(value).map(Object::toString).orElse(null);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            MDC.put((String)attributeName, (String)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            ThreadContextMDCServletFilter.addContextAttribute("remoteAddress", request.getRemoteAddr());
            ThreadContextMDCServletFilter.addContextAttribute("remoteUser", request.getRemoteUser());
            ThreadContextMDCServletFilter.addContextAttribute("serverName", request.getServerName());
            ThreadContextMDCServletFilter.addContextAttribute("serverPort", String.valueOf(request.getServerPort()));
            ThreadContextMDCServletFilter.addContextAttribute("locale", request.getLocale().getDisplayName());
            ThreadContextMDCServletFilter.addContextAttribute("contentType", request.getContentType());
            ThreadContextMDCServletFilter.addContextAttribute("contextPath", request.getContextPath());
            ThreadContextMDCServletFilter.addContextAttribute("localAddress", request.getLocalAddr());
            ThreadContextMDCServletFilter.addContextAttribute("localPort", String.valueOf(request.getLocalPort()));
            ThreadContextMDCServletFilter.addContextAttribute("remotePort", String.valueOf(request.getRemotePort()));
            ThreadContextMDCServletFilter.addContextAttribute("pathInfo", request.getPathInfo());
            ThreadContextMDCServletFilter.addContextAttribute("protocol", request.getProtocol());
            ThreadContextMDCServletFilter.addContextAttribute("authType", request.getAuthType());
            ThreadContextMDCServletFilter.addContextAttribute("method", request.getMethod());
            ThreadContextMDCServletFilter.addContextAttribute("queryString", request.getQueryString());
            ThreadContextMDCServletFilter.addContextAttribute("requestUri", request.getRequestURI());
            ThreadContextMDCServletFilter.addContextAttribute("scheme", request.getScheme());
            ThreadContextMDCServletFilter.addContextAttribute("timezone", TimeZone.getDefault().getDisplayName());
            String requestId = UUID.randomUUID().toString();
            ThreadContextMDCServletFilter.addContextAttribute("requestId", requestId);
            request.setAttribute("requestId", (Object)requestId);
            response.setHeader("X-RequestId", requestId);
            Optional.ofNullable(request.getSession(false)).ifPresent(session -> {
                ThreadContextMDCServletFilter.addContextAttribute("sessionId", session.getId());
                request.setAttribute("sessionId", (Object)session.getId());
                response.setHeader("X-SessionId", session.getId());
            });
            Map params = request.getParameterMap();
            MdcLoggingProperties mdc = this.casProperties.getLogging().getMdc();
            params.keySet().stream().filter(parameterName -> mdc.getParametersToExclude().stream().noneMatch(p -> RegexUtils.find((String)parameterName, (String)p))).forEach(parameterName -> {
                Object[] values = (String[])params.get(parameterName);
                ThreadContextMDCServletFilter.addContextAttribute(parameterName, Arrays.toString(values));
            });
            Collections.list(request.getAttributeNames()).forEach(a -> ThreadContextMDCServletFilter.addContextAttribute(a, request.getAttribute(a)));
            Enumeration requestHeaderNames = request.getHeaderNames();
            FunctionUtils.doIfNotNull((Object)requestHeaderNames, __ -> Collections.list(requestHeaderNames).stream().filter(header -> mdc.getHeadersToExclude().stream().noneMatch(excludedHeader -> RegexUtils.find((String)header, (String)excludedHeader))).forEach(h -> ThreadContextMDCServletFilter.addContextAttribute(h, request.getHeader(h))));
            this.ticketGrantingTicketCookieGenerator.ifAvailable(builder -> {
                String cookieValue = builder.retrieveCookieValue(request);
                if (StringUtils.isNotBlank((CharSequence)cookieValue)) {
                    Principal principal = ((TicketRegistrySupport)this.ticketRegistrySupport.getObject()).getAuthenticatedPrincipalFrom(cookieValue);
                    FunctionUtils.doIfNotNull((Object)principal, __ -> ThreadContextMDCServletFilter.addContextAttribute("principal", principal.getId()));
                }
            });
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            MDC.clear();
        }
    }

    @Generated
    public ThreadContextMDCServletFilter(ObjectProvider<TicketRegistrySupport> ticketRegistrySupport, ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator, CasConfigurationProperties casProperties) {
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.casProperties = casProperties;
    }
}

