/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.support.events.logout.CasRequestSingleLogoutEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketDestroyedEvent;
import org.apereo.cas.ticket.ExpirableTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.lock.LockRepository;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.transaction.annotation.Transactional;

@Transactional(transactionManager="ticketTransactionManager")
public class DefaultTicketRegistryCleaner
implements TicketRegistryCleaner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTicketRegistryCleaner.class);
    private final LockRepository lockRepository;
    private final ConfigurableApplicationContext applicationContext;
    private final TicketRegistry ticketRegistry;

    public int clean() {
        try {
            if (!this.isCleanerSupported()) {
                LOGGER.trace("Ticket registry cleaner is not supported by [{}]", (Object)this.getClass().getSimpleName());
                return 0;
            }
            return this.cleanInternal();
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return 0;
        }
    }

    public int cleanTicket(Ticket ticket) {
        return this.lockRepository.execute((Object)ticket.getId(), () -> {
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            if (ticket instanceof TicketGrantingTicket) {
                TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
                this.applicationContext.publishEvent((ApplicationEvent)new CasRequestSingleLogoutEvent((Object)this, tgt, clientInfo));
            }
            try {
                LOGGER.debug("Cleaning up expired ticket [{}]", (Object)ticket.getId());
                int nb = this.ticketRegistry.deleteTicket(ticket);
                if (ticket instanceof TicketGrantingTicket) {
                    TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
                    this.applicationContext.publishEvent((ApplicationEvent)new CasTicketGrantingTicketDestroyedEvent((Object)this, tgt, clientInfo));
                }
                return nb;
            }
            catch (Throwable e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                return 0;
            }
        }).orElse(0);
    }

    protected int cleanInternal() {
        try (Stream<Ticket> expiredTickets = this.ticketRegistry.stream().filter(Objects::nonNull).filter(ExpirableTicket::isExpired);){
            int ticketsDeleted = expiredTickets.mapToInt(this::cleanTicket).sum();
            LOGGER.info("[{}] expired tickets removed.", (Object)ticketsDeleted);
            int n = ticketsDeleted;
            return n;
        }
    }

    protected boolean isCleanerSupported() {
        return true;
    }

    @Generated
    public DefaultTicketRegistryCleaner(LockRepository lockRepository, ConfigurableApplicationContext applicationContext, TicketRegistry ticketRegistry) {
        this.lockRepository = lockRepository;
        this.applicationContext = applicationContext;
        this.ticketRegistry = ticketRegistry;
    }
}

