/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.configuration;

import com.icegreen.greenmail.base.GreenMailOperations;
import com.icegreen.greenmail.configuration.GreenMailConfiguration;
import com.icegreen.greenmail.configuration.UserBean;
import com.icegreen.greenmail.store.FolderException;
import java.io.IOException;
import java.nio.file.Paths;

public abstract class ConfiguredGreenMail
implements GreenMailOperations {
    private GreenMailConfiguration config;

    @Override
    public ConfiguredGreenMail withConfiguration(GreenMailConfiguration config) {
        this.config = config;
        return this;
    }

    protected void doConfigure() {
        if (this.config != null) {
            for (UserBean user : this.config.getUsersToCreate()) {
                this.setUser(user.getEmail(), user.getLogin(), user.getPassword());
            }
            this.getUserManager().setAuthRequired(!this.config.isAuthenticationDisabled());
            this.getUserManager().setSieveIgnoreDetail(this.config.isSieveIgnoreDetailEnabled());
            if (this.config.hasPreloadDir()) {
                try {
                    this.loadEmails(Paths.get(this.config.getPreloadDir(), new String[0]));
                }
                catch (FolderException | IOException e) {
                    throw new IllegalArgumentException("Can not preload emails", e);
                }
            }
        }
    }
}

