/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.http.handler;

import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.impl.bpmn.helper.AbstractClassDelegate;
import org.flowable.engine.impl.bpmn.http.delegate.HttpRequestHandlerInvocation;
import org.flowable.engine.impl.bpmn.http.delegate.HttpResponseHandlerInvocation;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.http.common.api.HttpRequest;
import org.flowable.http.common.api.HttpResponse;
import org.flowable.http.common.api.client.FlowableHttpClient;
import org.flowable.http.common.api.delegate.HttpRequestHandler;
import org.flowable.http.common.api.delegate.HttpResponseHandler;

public class ClassDelegateHttpHandler
extends AbstractClassDelegate
implements HttpRequestHandler,
HttpResponseHandler {
    private static final long serialVersionUID = 1L;

    public ClassDelegateHttpHandler(String className, List<FieldDeclaration> fieldDeclarations) {
        super(className, fieldDeclarations);
    }

    public ClassDelegateHttpHandler(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        super(clazz, fieldDeclarations);
    }

    public void handleHttpRequest(VariableContainer execution, HttpRequest httpRequest, FlowableHttpClient client) {
        HttpRequestHandler httpRequestHandler = this.getHttpRequestHandlerInstance();
        CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new HttpRequestHandlerInvocation(httpRequestHandler, execution, httpRequest, client));
    }

    public void handleHttpResponse(VariableContainer execution, HttpResponse httpResponse) {
        HttpResponseHandler httpResponseHandler = this.getHttpResponseHandlerInstance();
        CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new HttpResponseHandlerInvocation(httpResponseHandler, execution, httpResponse));
    }

    protected HttpRequestHandler getHttpRequestHandlerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof HttpRequestHandler) {
            return (HttpRequestHandler)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + String.valueOf(HttpRequestHandler.class));
    }

    protected HttpResponseHandler getHttpResponseHandlerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof HttpResponseHandler) {
            return (HttpResponseHandler)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + String.valueOf(HttpResponseHandler.class));
    }
}

