/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.api.CasConfigurationPropertiesSourceLocator;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;

public class DockerSecretsPropertySourceLocator
implements CasConfigurationPropertiesSourceLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerSecretsPropertySourceLocator.class);
    public static final String DEFAULT_SECRETS_DIR = "/run/secrets/";
    public static final String VAR_CAS_DOCKER_SECRETS_DIRECTORY = "CAS_DOCKER_SECRETS_DIRECTORY";
    public static final String VAR_CONTAINER = "CONTAINER";
    private static final String SECRETS_DIR = (String)StringUtils.defaultIfBlank((CharSequence)System.getProperty("CAS_DOCKER_SECRETS_DIRECTORY", System.getenv("/run/secrets/")), (CharSequence)"/run/secrets/");

    protected Map<String, Object> loadSecrets() {
        return (Map)FunctionUtils.doUnchecked(() -> {
            HashMap<String, String> secrets = new HashMap<String, String>();
            Path secretsDir = Paths.get(SECRETS_DIR, new String[0]);
            LOGGER.debug("Looking for Docker secrets in [{}]", (Object)secretsDir);
            if (Files.exists(secretsDir, new LinkOption[0]) && Files.isDirectory(secretsDir, new LinkOption[0])) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(secretsDir);){
                    for (Path entry : stream) {
                        String secretName = entry.getFileName().toString();
                        String secretValue = Files.readString(entry);
                        LOGGER.debug("Found Docker secret [{}] from [{}]", (Object)secretName, (Object)entry.getFileName());
                        secrets.put(secretName, secretValue);
                    }
                }
            }
            return secrets;
        });
    }

    @Override
    public Optional<PropertySource<?>> locate(Environment environment, ResourceLoader resourceLoader) {
        String container = System.getProperty(VAR_CONTAINER, System.getenv(VAR_CONTAINER));
        Map properties = StringUtils.isNotBlank((CharSequence)container) && BooleanUtils.toBoolean((String)container) ? this.loadSecrets() : Map.of();
        LOGGER.debug("Docker secrets loaded are [{}]", properties.keySet());
        return Optional.of(new MapPropertySource(this.getClass().getSimpleName(), properties));
    }
}

