/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.spinner;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidationError;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.ui.JQueryUIBehavior;
import org.wicketstuff.jquery.ui.form.spinner.ISpinnerListener;
import org.wicketstuff.jquery.ui.form.spinner.Spinner;
import org.wicketstuff.jquery.ui.form.spinner.SpinnerBehavior;

public class AjaxSpinner<T extends Number>
extends Spinner<T>
implements ISpinnerListener {
    private static final long serialVersionUID = 1L;

    public AjaxSpinner(String id, Class<T> type) {
        super(id, type);
    }

    public AjaxSpinner(String id, Options options, Class<T> type) {
        super(id, options, type);
    }

    public AjaxSpinner(String id, IModel<T> model, Class<T> type) {
        super(id, model, type);
    }

    public AjaxSpinner(String id, IModel<T> model, Options options, Class<T> type) {
        super(id, model, options, type);
    }

    @Override
    public boolean isOnSpinEventEnabled() {
        return true;
    }

    @Override
    public boolean isOnStopEventEnabled() {
        return false;
    }

    public T convertValue(String value) {
        IConverter converter = this.getConverter(this.getType());
        try {
            return (T)((Number)converter.convertToObject(value, this.getLocale()));
        }
        catch (ConversionException e) {
            this.error((IValidationError)this.newValidationError(e));
            return null;
        }
    }

    @Override
    public final void onSpin(AjaxRequestTarget target, String value) {
        this.onSpin(target, this.convertValue(value));
    }

    public void onSpin(AjaxRequestTarget target, T value) {
    }

    @Override
    public void onStop(AjaxRequestTarget target) {
    }

    @Override
    public JQueryUIBehavior newWidgetBehavior(String selector) {
        return new SpinnerBehavior(selector, this, this.options);
    }
}

