/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import lombok.Generated;
import org.apereo.cas.api.PasswordlessAuthenticationRequest;
import org.apereo.cas.api.PasswordlessTokenRepository;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.impl.token.PasswordlessAuthenticationToken;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.gen.DefaultRandomNumberGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;

public abstract class BasePasswordlessTokenRepository
implements PasswordlessTokenRepository {
    private static final int TOKEN_LENGTH = 6;
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private final RandomStringGenerator tokenGenerator = new DefaultRandomNumberGenerator(6);
    private final long tokenExpirationInSeconds;
    private final CipherExecutor<Serializable, String> cipherExecutor;

    @Override
    public PasswordlessAuthenticationToken createToken(PasswordlessUserAccount passwordlessAccount, PasswordlessAuthenticationRequest passwordlessRequest) {
        HashMap<String, String> properties = new HashMap<String, String>(passwordlessRequest.getProperties());
        properties.put("passwordlessRequestUsername", passwordlessRequest.getUsername());
        return ((PasswordlessAuthenticationToken.PasswordlessAuthenticationTokenBuilder)((PasswordlessAuthenticationToken.PasswordlessAuthenticationTokenBuilder)((PasswordlessAuthenticationToken.PasswordlessAuthenticationTokenBuilder)((PasswordlessAuthenticationToken.PasswordlessAuthenticationTokenBuilder)PasswordlessAuthenticationToken.builder().token(this.tokenGenerator.getNewString())).username(passwordlessAccount.getUsername())).expirationDate(ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(this.getTokenExpirationInSeconds()))).properties(properties)).build();
    }

    @Override
    public String encodeToken(PasswordlessAuthenticationToken token) {
        return (String)FunctionUtils.doUnchecked(() -> (String)this.getCipherExecutor().encode((Object)MAPPER.writeValueAsString((Object)token)));
    }

    protected PasswordlessAuthenticationToken decodePasswordlessAuthenticationToken(String token) {
        return (PasswordlessAuthenticationToken)FunctionUtils.doUnchecked(() -> {
            String decoded = (String)this.getCipherExecutor().decode((Object)token);
            return (PasswordlessAuthenticationToken)MAPPER.readValue(decoded, PasswordlessAuthenticationToken.class);
        });
    }

    @Generated
    protected BasePasswordlessTokenRepository(long tokenExpirationInSeconds, CipherExecutor<Serializable, String> cipherExecutor) {
        this.tokenExpirationInSeconds = tokenExpirationInSeconds;
        this.cipherExecutor = cipherExecutor;
    }

    @Generated
    public RandomStringGenerator getTokenGenerator() {
        return this.tokenGenerator;
    }

    @Generated
    public long getTokenExpirationInSeconds() {
        return this.tokenExpirationInSeconds;
    }

    @Generated
    public CipherExecutor<Serializable, String> getCipherExecutor() {
        return this.cipherExecutor;
    }
}

