/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.NamedObject;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationTrustedDeviceProviderAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class MultifactorAuthenticationAccountProfileWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public MultifactorAuthenticationAccountProfileWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(Integer.MAX_VALUE);
    }

    protected void doInitialize() {
        Flow accountFlow = this.getFlow("account");
        if (accountFlow != null) {
            ViewState accountView = (ViewState)this.getState(accountFlow, "myAccountProfile", ViewState.class);
            Set currentActions = Arrays.stream(accountView.getRenderActionList().toArray()).filter(MultifactorAuthenticationDeviceProviderAction.class::isInstance).map(MultifactorAuthenticationDeviceProviderAction.class::cast).map(NamedObject::getName).collect(Collectors.toSet());
            List<Action> providerActions = this.applicationContext.getBeansOfType(MultifactorAuthenticationDeviceProviderAction.class).values().stream().filter(BeanSupplier::isNotProxy).filter(action -> !currentActions.contains(action.getName())).collect(Collectors.toList());
            AnnotationAwareOrderComparator.sort(providerActions);
            accountView.getRenderActionList().addAll(providerActions.toArray(CasWebflowConfigurer.EMPTY_ACTIONS_ARRAY));
            Set currentTrustActions = Arrays.stream(accountView.getRenderActionList().toArray()).filter(MultifactorAuthenticationTrustedDeviceProviderAction.class::isInstance).map(MultifactorAuthenticationTrustedDeviceProviderAction.class::cast).map(NamedObject::getName).collect(Collectors.toSet());
            List<Action> trustedActions = this.applicationContext.getBeansOfType(MultifactorAuthenticationTrustedDeviceProviderAction.class).values().stream().filter(BeanSupplier::isNotProxy).filter(action -> !currentTrustActions.contains(action.getName())).collect(Collectors.toList());
            AnnotationAwareOrderComparator.sort(trustedActions);
            accountView.getRenderActionList().addAll(trustedActions.toArray(CasWebflowConfigurer.EMPTY_ACTIONS_ARRAY));
        }
    }
}

