/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class JPAJobStatusDAO
implements JobStatusDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(JobStatusDAO.class);
    protected final EntityManager entityManager;

    public JPAJobStatusDAO(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public boolean lock(String key) {
        if (!"UNKNOWN".equals(this.get(key))) {
            LOG.debug("Job {} already locked", (Object)key);
            return false;
        }
        try {
            Query query = this.entityManager.createNativeQuery("INSERT INTO JobStatus(id, jobStatus) VALUES (?,?)");
            query.setParameter(1, (Object)key);
            query.setParameter(2, (Object)"JOB_FIRED");
            query.executeUpdate();
            LOG.debug("Job {} locked", (Object)key);
            return true;
        }
        catch (Exception e) {
            LOG.debug("Could not lock job {}", (Object)key, (Object)e);
            return false;
        }
    }

    public void unlock(String key) {
        Query query = this.entityManager.createNativeQuery("DELETE FROM JobStatus WHERE id=?");
        query.setParameter(1, (Object)key);
        query.executeUpdate();
        LOG.debug("Job {} unlocked", (Object)key);
    }

    public void set(String key, String status) {
        Query query = this.entityManager.createNativeQuery("UPDATE JobStatus SET jobStatus=? WHERE id=?");
        query.setParameter(1, (Object)("UNKNOWN".equals(status) ? "Status UNKNOWN" : status));
        query.setParameter(2, (Object)key);
        query.executeUpdate();
    }

    @Transactional(readOnly=true)
    public String get(String key) {
        Query query = this.entityManager.createNativeQuery("SELECT jobStatus FROM JobStatus WHERE id=?");
        query.setParameter(1, (Object)key);
        List result = query.getResultList();
        return result.isEmpty() ? "UNKNOWN" : result.getFirst().toString();
    }
}

