/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.credentials.extractor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.core.credentials.CredentialSource;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormExtractor
implements CredentialsExtractor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FormExtractor.class);
    private final String usernameParameter;
    private final String passwordParameter;
    private ExtractionMode extractionMode = ExtractionMode.ALL;

    @Override
    public Optional<Credentials> extract(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        Optional<Object> username = Optional.empty();
        Optional<Object> password = Optional.empty();
        switch (this.extractionMode) {
            case ALL: {
                username = webContext.getRequestParameter(this.usernameParameter);
                password = webContext.getRequestParameter(this.passwordParameter);
                break;
            }
            case QUERY_PARAM: {
                try {
                    if (WebContextHelper.isQueryStringParameter(webContext, this.usernameParameter)) {
                        username = webContext.getRequestParameter(this.usernameParameter);
                    }
                    if (!WebContextHelper.isQueryStringParameter(webContext, this.passwordParameter)) break;
                    password = webContext.getRequestParameter(this.passwordParameter);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
                break;
            }
            case REQUEST_BODY: {
                if (!"POST".equalsIgnoreCase(webContext.getRequestMethod())) break;
                if (!WebContextHelper.isQueryStringParameter(webContext, this.usernameParameter)) {
                    username = webContext.getRequestParameter(this.usernameParameter);
                }
                if (WebContextHelper.isQueryStringParameter(webContext, this.passwordParameter)) break;
                password = webContext.getRequestParameter(this.passwordParameter);
            }
        }
        if (username.isEmpty() || password.isEmpty()) {
            return Optional.empty();
        }
        UsernamePasswordCredentials upc = new UsernamePasswordCredentials((String)username.get(), (String)password.get());
        upc.setSource(CredentialSource.FORM.name());
        return Optional.of(upc);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExtractionMode getExtractionMode() {
        return this.extractionMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FormExtractor(String usernameParameter, String passwordParameter) {
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setExtractionMode(ExtractionMode extractionMode) {
        this.extractionMode = extractionMode;
    }

    public static enum ExtractionMode {
        QUERY_PARAM,
        REQUEST_BODY,
        ALL;

    }
}

