/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.layout.AnyLayout;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.layout.AnyLayoutWrapper;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AnyPanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.UserDirectoryPanel;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonEditorPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.role.RoleWrapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class RoleDirectoryPanel
extends DirectoryPanel<RoleTO, RoleWrapper, RoleDataProvider, RoleRestClient> {
    private static final long serialVersionUID = -1100228004207271270L;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected AnyTypeClassRestClient anyTypeClassRestClient;
    @SpringBean
    protected UserRestClient userRestClient;
    protected final BaseModal<String> utilityModal = new BaseModal("outer");
    protected final BaseModal<Serializable> membersModal = new BaseModal("outer");

    protected RoleDirectoryPanel(String id, Builder builder) {
        super(id, builder);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"ROLE_CREATE");
        this.setReadOnly(!SyncopeConsoleSession.get().owns("ROLE_UPDATE", new String[0]));
        this.disableCheckBoxes();
        this.setShowResultPanel(true);
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
        this.addOuterObject(new Component[]{this.utilityModal});
        this.setWindowClosedReloadCallback(this.utilityModal);
        this.utilityModal.size(Modal.Size.Large);
        this.utilityModal.addSubmitButton();
        this.addOuterObject(new Component[]{this.membersModal});
        this.membersModal.size(Modal.Size.Large);
    }

    @Override
    protected RoleDataProvider dataProvider() {
        return new RoleDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "role.paginator.rows";
    }

    @Override
    protected List<IColumn<RoleTO, String>> getColumns() {
        ArrayList<IColumn<RoleTO, String>> columns = new ArrayList<IColumn<RoleTO, String>>();
        columns.add((IColumn<RoleTO, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"key", "key"));
        columns.add((IColumn<RoleTO, String>)new PropertyColumn((IModel)new ResourceModel("entitlements", "Entitlements"), null, "entitlements"));
        columns.add((IColumn<RoleTO, String>)new PropertyColumn((IModel)new ResourceModel("realms"), null, "realms"));
        columns.add((IColumn<RoleTO, String>)new PropertyColumn((IModel)new ResourceModel("dynRealms"), null, "dynRealms"));
        return columns;
    }

    @Override
    public ActionsPanel<RoleTO> getActions(final IModel<RoleTO> model) {
        ActionsPanel<RoleTO> panel = super.getActions(model);
        panel.add(new ActionLink<RoleTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, RoleTO ignore) {
                RoleDirectoryPanel.this.send((IEventSink)RoleDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((Object)new RoleWrapper(((RoleRestClient)RoleDirectoryPanel.this.restClient).read(((RoleTO)model.getObject()).getKey()))), target));
            }
        }, ActionLink.ActionType.EDIT, "ROLE_READ");
        panel.add(new ActionLink<RoleTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, RoleTO ignore) {
                RoleTO clone = (RoleTO)SerializationUtils.clone((Serializable)((RoleTO)model.getObject()));
                clone.setKey(null);
                RoleDirectoryPanel.this.send((IEventSink)RoleDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.NewItemActionEvent((Serializable)((Object)new RoleWrapper(clone)), target));
            }
        }, ActionLink.ActionType.CLONE, "ROLE_CREATE");
        panel.add(new ActionLink<RoleTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, RoleTO ignore) {
                AnyTypeTO userType = RoleDirectoryPanel.this.anyTypeRestClient.read(AnyTypeKind.USER.name());
                AnyLayout layout = AnyLayoutUtils.fetch((RoleRestClient)RoleDirectoryPanel.this.restClient, RoleDirectoryPanel.this.anyTypeRestClient.list());
                Object anyPanel = new AnyPanel.Builder(layout.getAnyPanelClass(), "content", userType, null, layout, false, RoleDirectoryPanel.this.pageRef).build((id, anyTypeTO, realmTO, anyLayout, pageRef) -> {
                    String query = SyncopeClient.getUserSearchConditionBuilder().inRoles(((RoleTO)model.getObject()).getKey(), new String[0]).query();
                    WizardMgtPanel panel = new UserDirectoryPanel.Builder(RoleDirectoryPanel.this.anyTypeClassRestClient.list(anyTypeTO.getClasses()), RoleDirectoryPanel.this.userRestClient, anyTypeTO.getKey(), pageRef).setRealm("/").setFiltered(true).setFiql(query).disableCheckBoxes().addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(new UserTO(), anyTypeTO.getClasses(), anyLayout.getUser(), RoleDirectoryPanel.this.userRestClient, pageRef), false).setWizardInModal(false).build(id);
                    MetaDataRoleAuthorizationStrategy.authorize(panel, (Action)WebPage.RENDER, (String)"USER_SEARCH");
                    return panel;
                });
                RoleDirectoryPanel.this.membersModal.header((IModel)new StringResourceModel("role.members", (Component)RoleDirectoryPanel.this, model));
                RoleDirectoryPanel.this.membersModal.setContent((ModalPanel)anyPanel);
                RoleDirectoryPanel.this.membersModal.show(true);
                target.add(new Component[]{RoleDirectoryPanel.this.membersModal});
            }
        }, ActionLink.ActionType.MEMBERS, "USER_SEARCH");
        panel.add(new ActionLink<RoleTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, RoleTO ignore) {
                final AnyLayoutWrapper wrapper = new AnyLayoutWrapper(((RoleTO)model.getObject()).getKey(), AnyLayoutUtils.defaultIfEmpty(((RoleRestClient)RoleDirectoryPanel.this.restClient).readAnyLayout(((RoleTO)model.getObject()).getKey()), RoleDirectoryPanel.this.anyTypeRestClient.list()));
                RoleDirectoryPanel.this.utilityModal.header((IModel)new ResourceModel("console.layout.info", "JSON Content"));
                RoleDirectoryPanel.this.utilityModal.setContent((ModalPanel)new JsonEditorPanel(RoleDirectoryPanel.this.utilityModal, (IModel)new PropertyModel((Object)wrapper, "content"), false, RoleDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = -8927036362466990179L;

                    @Override
                    public void onSubmit(AjaxRequestTarget target) {
                        try {
                            ((RoleRestClient)RoleDirectoryPanel.this.restClient).setAnyLayout(wrapper.getKey(), wrapper.getContent());
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                            this.modal.show(false);
                            this.modal.close((IPartialPageRequestHandler)target);
                        }
                        catch (Exception e) {
                            LOG.error("While updating console layout for role {}", (Object)wrapper.getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                });
                RoleDirectoryPanel.this.utilityModal.show(true);
                target.add(new Component[]{RoleDirectoryPanel.this.utilityModal});
            }
        }, ActionLink.ActionType.LAYOUT_EDIT, "ROLE_UPDATE");
        panel.add(new ActionLink<RoleTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, RoleTO ignore) {
                try {
                    ((RoleRestClient)RoleDirectoryPanel.this.restClient).delete(((RoleTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)RoleDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{RoleDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting object {}", (Object)((RoleTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)RoleDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "ROLE_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of(ActionLink.ActionType.DELETE);
    }

    protected class RoleDataProvider
    extends DirectoryDataProvider<RoleTO> {
        private static final long serialVersionUID = 6267494272884913376L;
        private final SortableDataProviderComparator<RoleTO> comparator;

        public RoleDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator<RoleTO>(this);
        }

        public Iterator<RoleTO> iterator(long first, long count) {
            List<RoleTO> result = ((RoleRestClient)RoleDirectoryPanel.this.restClient).list();
            result.sort(this.comparator);
            return result.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((RoleRestClient)RoleDirectoryPanel.this.restClient).list().size();
        }

        public IModel<RoleTO> model(RoleTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    public static abstract class Builder
    extends DirectoryPanel.Builder<RoleTO, RoleWrapper, RoleRestClient> {
        private static final long serialVersionUID = 5088962796986706805L;

        public Builder(RoleRestClient restClient, PageReference pageRef) {
            super(restClient, pageRef);
        }

        @Override
        protected WizardMgtPanel<RoleWrapper> newInstance(String id, boolean wizardInModal) {
            return new RoleDirectoryPanel(id, this);
        }
    }
}

