/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import org.apache.syncope.wa.bootstrap.WAProperties;
import org.apache.syncope.wa.starter.config.WARefreshContextJob;
import org.apereo.cas.config.GoogleAuthenticatorLdapConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.CasConfigurationPropertiesValidator;
import org.apereo.cas.oidc.config.OidcJwksJpaConfiguration;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.jersey.JerseyAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication(exclude={GoogleAuthenticatorLdapConfiguration.class, OidcJwksJpaConfiguration.class, HibernateJpaAutoConfiguration.class, JerseyAutoConfiguration.class, GroovyTemplateAutoConfiguration.class, GsonAutoConfiguration.class, JmxAutoConfiguration.class, DataSourceAutoConfiguration.class, RedisAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, CassandraAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class, RedisRepositoriesAutoConfiguration.class})
@EnableConfigurationProperties(value={WAProperties.class, CasConfigurationProperties.class})
@EnableAsync(proxyTargetClass=false)
@EnableAspectJAutoProxy(proxyTargetClass=false)
@EnableTransactionManagement(proxyTargetClass=false)
@EnableScheduling
public class SyncopeWAApplication
extends SpringBootServletInitializer {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeWAApplication.class);

    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{SyncopeWAApplication.class}).properties(Map.of("spring.config.name", "wa", "spring.cloud.bootstrap.name", "wa")).build().run(args);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.properties(Map.of("spring.config.name", "wa", "spring.cloud.bootstrap.name", "wa")).sources(new Class[]{SyncopeWAApplication.class});
    }

    @EventListener
    public void handleApplicationReadyEvent(ApplicationReadyEvent event) {
        new CasConfigurationPropertiesValidator(event.getApplicationContext()).validate();
        WAProperties waProperties = (WAProperties)event.getApplicationContext().getBean(WAProperties.class);
        SchedulerFactoryBean scheduler = (SchedulerFactoryBean)event.getApplicationContext().getBean(SchedulerFactoryBean.class);
        this.scheduleJobToRefreshContext(waProperties, scheduler);
    }

    protected void scheduleJobToRefreshContext(WAProperties waProperties, SchedulerFactoryBean scheduler) {
        try {
            Date date = Date.from(LocalDateTime.now().plusSeconds(waProperties.getContextRefreshDelay()).atZone(ZoneId.systemDefault()).toInstant());
            Trigger trigger = TriggerBuilder.newTrigger().startAt(date).build();
            JobKey jobKey = new JobKey(((Object)((Object)this)).getClass().getSimpleName());
            JobDetail job = JobBuilder.newJob(WARefreshContextJob.class).withIdentity(jobKey).build();
            LOG.info("Scheduled job to refresh application context @ [{}]", (Object)date);
            scheduler.getScheduler().scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Could not schedule refresh job", e);
        }
    }
}

