/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.cmd;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.eventregistry.impl.persistence.deploy.EventDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class SetEventDefinitionCategoryCmd
implements Command<Void> {
    protected String eventDefinitionId;
    protected String category;

    public SetEventDefinitionCategoryCmd(String eventDefinitionId, String category) {
        this.eventDefinitionId = eventDefinitionId;
        this.category = category;
    }

    public Void execute(CommandContext commandContext) {
        if (this.eventDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Event definition id is null");
        }
        EventDefinitionEntity eventDefinition = (EventDefinitionEntity)CommandContextUtil.getEventDefinitionEntityManager(commandContext).findById(this.eventDefinitionId);
        if (eventDefinition == null) {
            throw new FlowableObjectNotFoundException("No event definition found for id = '" + this.eventDefinitionId + "'");
        }
        eventDefinition.setCategory(this.category);
        DeploymentCache<EventDefinitionCacheEntry> eventDefinitionCache = CommandContextUtil.getEventRegistryConfiguration().getEventDefinitionCache();
        if (eventDefinitionCache != null) {
            eventDefinitionCache.remove(this.eventDefinitionId);
        }
        CommandContextUtil.getEventDefinitionEntityManager(commandContext).update(eventDefinition);
        return null;
    }

    public String getEventDefinitionId() {
        return this.eventDefinitionId;
    }

    public void setEventDefinitionId(String eventDefinitionId) {
        this.eventDefinitionId = eventDefinitionId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

