/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.type.ModeEnum;

public final class StyleUtil {
    private static final StyleUtil INSTANCE = new StyleUtil();
    private static final BoxSideSelector RIGHT_SIDE = new BoxSideSelector(){

        @Override
        public JRBoxPen getPen(JRLineBox lineBox) {
            return lineBox.getRightPen();
        }

        @Override
        public Integer getPadding(JRLineBox lineBox) {
            return lineBox.getOwnRightPadding();
        }
    };
    private static final BoxSideSelector TOP_SIDE = new BoxSideSelector(){

        @Override
        public JRBoxPen getPen(JRLineBox lineBox) {
            return lineBox.getTopPen();
        }

        @Override
        public Integer getPadding(JRLineBox lineBox) {
            return lineBox.getOwnTopPadding();
        }
    };
    private static final BoxSideSelector LEFT_SIDE = new BoxSideSelector(){

        @Override
        public JRBoxPen getPen(JRLineBox lineBox) {
            return lineBox.getLeftPen();
        }

        @Override
        public Integer getPadding(JRLineBox lineBox) {
            return lineBox.getOwnLeftPadding();
        }
    };
    private static final BoxSideSelector BOTTOM_SIDE = new BoxSideSelector(){

        @Override
        public JRBoxPen getPen(JRLineBox lineBox) {
            return lineBox.getBottomPen();
        }

        @Override
        public Integer getPadding(JRLineBox lineBox) {
            return lineBox.getOwnBottomPadding();
        }
    };

    public static StyleUtil instance() {
        return INSTANCE;
    }

    private StyleUtil() {
    }

    public ModeEnum resolveMode(JRStyleContainer styleContainer) {
        JRStyle style = styleContainer.getStyle();
        if (style != null) {
            ModeEnum styleMode = style.getOwnMode();
            if (styleMode != null) {
                JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
                if (conditionalStyles != null) {
                    for (JRConditionalStyle conditionalStyle : conditionalStyles) {
                        ModeEnum conditionalMode = conditionalStyle.getOwnMode();
                        if (conditionalMode == null || conditionalMode == styleMode) continue;
                        return null;
                    }
                }
                return styleMode;
            }
            return this.resolveMode(style);
        }
        if (styleContainer.getStyleNameReference() != null) {
            return null;
        }
        return ModeEnum.TRANSPARENT;
    }

    public ModeEnum resolveElementMode(JRElement element) {
        ModeEnum elementMode = element.getOwnMode();
        if (elementMode != null) {
            return elementMode;
        }
        return this.resolveMode(element);
    }

    public boolean hasBox(JRBoxContainer boxContainer) {
        return this.hasBorder(boxContainer, RIGHT_SIDE) || this.hasBorder(boxContainer, TOP_SIDE) || this.hasBorder(boxContainer, LEFT_SIDE) || this.hasBorder(boxContainer, BOTTOM_SIDE) || this.hasPadding(boxContainer, RIGHT_SIDE) || this.hasPadding(boxContainer, TOP_SIDE) || this.hasPadding(boxContainer, LEFT_SIDE) || this.hasPadding(boxContainer, BOTTOM_SIDE);
    }

    protected boolean hasBorder(JRBoxContainer boxContainer, BoxSideSelector selector) {
        JRLineBox lineBox = boxContainer.getLineBox();
        Float rightLineWidth = selector.getPen(lineBox).getOwnLineWidth();
        if (rightLineWidth != null) {
            return rightLineWidth.floatValue() > 0.0f;
        }
        Float lineWidth = lineBox.getPen().getOwnLineWidth();
        if (lineWidth != null) {
            return lineWidth.floatValue() > 0.0f;
        }
        JRStyle style = boxContainer.getStyle();
        if (style != null) {
            return this.hasBorder(style, selector);
        }
        String styleReference = boxContainer.getStyleNameReference();
        return styleReference != null;
    }

    protected boolean hasPadding(JRBoxContainer boxContainer, BoxSideSelector penSelector) {
        JRLineBox lineBox = boxContainer.getLineBox();
        Integer sidePadding = penSelector.getPadding(lineBox);
        if (sidePadding != null) {
            return sidePadding > 0;
        }
        Integer padding = lineBox.getOwnPadding();
        if (padding != null) {
            return padding > 0;
        }
        JRStyle style = boxContainer.getStyle();
        if (style != null) {
            return this.hasPadding(style, penSelector);
        }
        String styleReference = boxContainer.getStyleNameReference();
        return styleReference != null;
    }

    public static void appendStyle(JRStyle destStyle, JRStyle srcStyle) {
        if (srcStyle.getOwnMode() != null) {
            destStyle.setMode(srcStyle.getOwnMode());
        }
        if (srcStyle.getOwnForecolor() != null) {
            destStyle.setForecolor(srcStyle.getOwnForecolor());
        }
        if (srcStyle.getOwnBackcolor() != null) {
            destStyle.setBackcolor(srcStyle.getOwnBackcolor());
        }
        StyleUtil.appendPen(destStyle.getLinePen(), srcStyle.getLinePen());
        if (srcStyle.getOwnFill() != null) {
            destStyle.setFill(srcStyle.getOwnFill());
        }
        if (srcStyle.getOwnRadius() != null) {
            destStyle.setRadius(srcStyle.getOwnRadius());
        }
        if (srcStyle.getOwnScaleImage() != null) {
            destStyle.setScaleImage(srcStyle.getOwnScaleImage());
        }
        if (srcStyle.getOwnHorizontalTextAlign() != null) {
            destStyle.setHorizontalTextAlign(srcStyle.getOwnHorizontalTextAlign());
        }
        if (srcStyle.getOwnHorizontalImageAlign() != null) {
            destStyle.setHorizontalImageAlign(srcStyle.getOwnHorizontalImageAlign());
        }
        if (srcStyle.getOwnVerticalTextAlign() != null) {
            destStyle.setVerticalTextAlign(srcStyle.getOwnVerticalTextAlign());
        }
        if (srcStyle.getOwnVerticalImageAlign() != null) {
            destStyle.setVerticalImageAlign(srcStyle.getOwnVerticalImageAlign());
        }
        StyleUtil.appendBox(destStyle.getLineBox(), srcStyle.getLineBox());
        StyleUtil.appendParagraph(destStyle.getParagraph(), srcStyle.getParagraph());
        if (srcStyle.getOwnRotation() != null) {
            destStyle.setRotation(srcStyle.getOwnRotation());
        }
        if (srcStyle.getOwnMarkup() != null) {
            destStyle.setMarkup(srcStyle.getOwnMarkup());
        }
        if (srcStyle.getOwnPattern() != null) {
            destStyle.setPattern(srcStyle.getOwnPattern());
        }
        if (srcStyle.getOwnFontName() != null) {
            destStyle.setFontName(srcStyle.getOwnFontName());
        }
        if (srcStyle.isOwnBold() != null) {
            destStyle.setBold(srcStyle.isOwnBold());
        }
        if (srcStyle.isOwnItalic() != null) {
            destStyle.setItalic(srcStyle.isOwnItalic());
        }
        if (srcStyle.isOwnUnderline() != null) {
            destStyle.setUnderline(srcStyle.isOwnUnderline());
        }
        if (srcStyle.isOwnStrikeThrough() != null) {
            destStyle.setStrikeThrough(srcStyle.isOwnStrikeThrough());
        }
        if (srcStyle.getOwnFontSize() != null) {
            destStyle.setFontSize(srcStyle.getOwnFontSize());
        }
        if (srcStyle.getOwnPdfFontName() != null) {
            destStyle.setPdfFontName(srcStyle.getOwnPdfFontName());
        }
        if (srcStyle.getOwnPdfEncoding() != null) {
            destStyle.setPdfEncoding(srcStyle.getOwnPdfEncoding());
        }
        if (srcStyle.isOwnPdfEmbedded() != null) {
            destStyle.setPdfEmbedded(srcStyle.isOwnPdfEmbedded());
        }
        if (srcStyle.isOwnBlankWhenNull() != null) {
            destStyle.setBlankWhenNull(srcStyle.isOwnBlankWhenNull());
        }
    }

    public static void appendPen(JRPen destPen, JRPen srcPen) {
        if (srcPen.getOwnLineWidth() != null) {
            destPen.setLineWidth(srcPen.getOwnLineWidth());
        }
        if (srcPen.getOwnLineStyle() != null) {
            destPen.setLineStyle(srcPen.getOwnLineStyle());
        }
        if (srcPen.getOwnLineColor() != null) {
            destPen.setLineColor(srcPen.getOwnLineColor());
        }
    }

    public static void appendBox(JRLineBox destBox, JRLineBox srcBox) {
        StyleUtil.appendPen(destBox.getPen(), srcBox.getPen());
        StyleUtil.appendPen(destBox.getTopPen(), srcBox.getTopPen());
        StyleUtil.appendPen(destBox.getLeftPen(), srcBox.getLeftPen());
        StyleUtil.appendPen(destBox.getBottomPen(), srcBox.getBottomPen());
        StyleUtil.appendPen(destBox.getRightPen(), srcBox.getRightPen());
        if (srcBox.getOwnPadding() != null) {
            destBox.setPadding(srcBox.getOwnPadding());
        }
        if (srcBox.getOwnTopPadding() != null) {
            destBox.setTopPadding(srcBox.getOwnTopPadding());
        }
        if (srcBox.getOwnLeftPadding() != null) {
            destBox.setLeftPadding(srcBox.getOwnLeftPadding());
        }
        if (srcBox.getOwnBottomPadding() != null) {
            destBox.setBottomPadding(srcBox.getOwnBottomPadding());
        }
        if (srcBox.getOwnRightPadding() != null) {
            destBox.setRightPadding(srcBox.getOwnRightPadding());
        }
    }

    public static void appendParagraph(JRParagraph destParagraph, JRParagraph srcParagraph) {
        if (srcParagraph.getOwnLineSpacing() != null) {
            destParagraph.setLineSpacing(srcParagraph.getOwnLineSpacing());
        }
        if (srcParagraph.getOwnLeftIndent() != null) {
            destParagraph.setLeftIndent(srcParagraph.getOwnLeftIndent());
        }
        if (srcParagraph.getOwnRightIndent() != null) {
            destParagraph.setRightIndent(srcParagraph.getOwnRightIndent());
        }
        if (srcParagraph.getOwnSpacingBefore() != null) {
            destParagraph.setSpacingBefore(srcParagraph.getOwnSpacingBefore());
        }
        if (srcParagraph.getOwnSpacingAfter() != null) {
            destParagraph.setSpacingAfter(srcParagraph.getOwnSpacingAfter());
        }
        if (srcParagraph.getOwnTabStopWidth() != null) {
            destParagraph.setTabStopWidth(srcParagraph.getOwnTabStopWidth());
        }
    }

    private static interface BoxSideSelector {
        public JRBoxPen getPen(JRLineBox var1);

        public Integer getPadding(JRLineBox var1);
    }
}

