/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractDerivedCRS;
import org.apache.sis.referencing.crs.ExplicitParameters;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.Projection;

@XmlType(name="ProjectedCRSType", propOrder={"baseCRS", "coordinateSystem"})
@XmlRootElement(name="ProjectedCRS")
public class DefaultProjectedCRS
extends AbstractDerivedCRS<Projection>
implements ProjectedCRS {
    private static final long serialVersionUID = -4502680112031773028L;

    public DefaultProjectedCRS(Map<String, ?> properties, GeographicCRS baseCRS, Conversion baseToDerived, CartesianCS derivedCS) throws MismatchedDimensionException {
        super(properties, (SingleCRS)DefaultProjectedCRS.checkDimensions((GeodeticCRS)baseCRS, derivedCS), baseToDerived, (CoordinateSystem)derivedCS);
    }

    private static GeodeticCRS checkDimensions(GeodeticCRS baseCRS, CartesianCS derivedCS) {
        int n = baseCRS.getCoordinateSystem().getDimension();
        if (derivedCS != null) {
            n = Math.max(n, derivedCS.getDimension());
        }
        n = Math.max(2, Math.min(3, n));
        ArgumentChecks.ensureDimensionMatches((String)"baseCRS", (int)n, (CoordinateReferenceSystem)baseCRS);
        ArgumentChecks.ensureDimensionMatches((String)"derivedCS", (int)n, (CoordinateSystem)derivedCS);
        return baseCRS;
    }

    private DefaultProjectedCRS(DefaultProjectedCRS original, AbstractCS derivedCS) {
        super(original, derivedCS);
    }

    protected DefaultProjectedCRS(ProjectedCRS crs) {
        super((GeneralDerivedCRS)crs);
    }

    public static DefaultProjectedCRS castOrCopy(ProjectedCRS object) {
        return object == null || object instanceof DefaultProjectedCRS ? (DefaultProjectedCRS)object : new DefaultProjectedCRS(object);
    }

    @Override
    final Class<Projection> getConversionType() {
        return Projection.class;
    }

    public Class<? extends ProjectedCRS> getInterface() {
        return ProjectedCRS.class;
    }

    public GeodeticDatum getDatum() {
        return this.getBaseCRS().getDatum();
    }

    public DefaultDatumEnsemble<GeodeticDatum> getDatumEnsemble() {
        return DefaultProjectedCRS.getDatumEnsemble((CoordinateReferenceSystem)this.getBaseCRS());
    }

    @XmlElement(name="baseGeodeticCRS", required=true)
    public GeographicCRS getBaseCRS() {
        Projection projection = (Projection)super.getConversionFromBase();
        return projection != null ? (GeographicCRS)projection.getSourceCRS() : null;
    }

    @Override
    public Projection getConversionFromBase() {
        return (Projection)super.getConversionFromBase();
    }

    @XmlElement(name="cartesianCS", required=true)
    public final CartesianCS getCoordinateSystem() {
        return (CartesianCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultProjectedCRS forConvention(AxesConvention convention) {
        return (DefaultProjectedCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(AbstractCS cs) {
        return new DefaultProjectedCRS(this, cs);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        return super.equals(object, mode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isBaseCRS;
        if (super.getConversionFromBase() == null) {
            return super.formatTo(formatter);
        }
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        CartesianCS cs = this.getCoordinateSystem();
        GeographicCRS baseCRS = this.getBaseCRS();
        Unit<?> lengthUnit = ReferencingUtilities.getUnit((CoordinateSystem)cs);
        Unit<Angle> angularUnit = AxisDirections.getAngularUnit(baseCRS.getCoordinateSystem(), null);
        Unit<Angle> oldAngle = formatter.addContextualUnit(angularUnit);
        Unit<?> oldLength = formatter.addContextualUnit(lengthUnit);
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable((CoordinateReferenceSystem)baseCRS));
        formatter.newLine();
        ExplicitParameters p = new ExplicitParameters(this, "Conversion");
        if (isWKT1) {
            p.append(formatter);
            isBaseCRS = false;
        } else {
            formatter.append(p);
            isBaseCRS = DefaultProjectedCRS.isBaseCRS(formatter);
        }
        if (!isBaseCRS || convention == Convention.INTERNAL) {
            this.formatCS(formatter, (CoordinateSystem)cs, lengthUnit, isWKT1);
        }
        formatter.restoreContextualUnit(lengthUnit, oldLength);
        formatter.restoreContextualUnit(angularUnit, oldAngle);
        return isWKT1 ? "ProjCS" : (isBaseCRS ? "BaseProjCRS" : formatter.shortOrLong("ProjCRS", "ProjectedCRS"));
    }

    private DefaultProjectedCRS() {
    }

    private void setBaseCRS(GeographicCRS crs) {
        this.setBaseCRS("baseGeodeticCRS", (SingleCRS)crs);
    }

    private void setCoordinateSystem(CartesianCS cs) {
        this.setCoordinateSystem("cartesianCS", (CoordinateSystem)cs);
    }
}

