/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Map;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractSingleCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultEngineeringDatum;
import org.apache.sis.xml.bind.referencing.CS_CoordinateSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.datum.EngineeringDatum;

@XmlType(name="EngineeringCRSType", propOrder={"abstractCS", "affineCS", "cartesianCS", "cylindricalCS", "linearCS", "polarCS", "sphericalCS", "userDefinedCS", "datum"})
@XmlRootElement(name="EngineeringCRS")
public class DefaultEngineeringCRS
extends AbstractSingleCRS<EngineeringDatum>
implements EngineeringCRS {
    private static final long serialVersionUID = -5716016061569447341L;
    private static final Class<?>[] SPECIALIZED_TYPES = new Class[]{AffineCS.class, SphericalCS.class, CylindricalCS.class, PolarCS.class, LinearCS.class, UserDefinedCS.class};

    public DefaultEngineeringCRS(Map<String, ?> properties, EngineeringDatum datum, DefaultDatumEnsemble<EngineeringDatum> ensemble, CoordinateSystem cs) {
        super(properties, EngineeringDatum.class, datum, ensemble, cs);
    }

    private DefaultEngineeringCRS(DefaultEngineeringCRS original, AbstractCS cs) {
        super(original, null, cs);
    }

    protected DefaultEngineeringCRS(EngineeringCRS crs) {
        super((SingleCRS)crs);
    }

    public static DefaultEngineeringCRS castOrCopy(EngineeringCRS object) {
        return object == null || object instanceof DefaultEngineeringCRS ? (DefaultEngineeringCRS)object : new DefaultEngineeringCRS(object);
    }

    @Override
    public Class<? extends EngineeringCRS> getInterface() {
        return EngineeringCRS.class;
    }

    @Override
    @XmlElement(name="engineeringDatum", required=true)
    public EngineeringDatum getDatum() {
        return (EngineeringDatum)super.getDatum();
    }

    @Override
    public DefaultDatumEnsemble<EngineeringDatum> getDatumEnsemble() {
        return super.getDatumEnsemble();
    }

    @Override
    public DefaultEngineeringCRS forConvention(AxesConvention convention) {
        return (DefaultEngineeringCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(AbstractCS cs) {
        return new DefaultEngineeringCRS(this, cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return formatter.getConvention().majorVersion() == 1 ? "Local_CS" : (DefaultEngineeringCRS.isBaseCRS(formatter) ? "BaseEngCRS" : formatter.shortOrLong("EngCRS", "EngineeringCRS"));
    }

    @Override
    final void formatDatum(Formatter formatter) {
        DefaultEngineeringCRS.formatDatum(formatter, this, this.getDatum(), DefaultEngineeringDatum::castOrCopy, DatumOrEnsemble::asDatum);
    }

    private DefaultEngineeringCRS() {
    }

    private void setDatum(EngineeringDatum value) {
        this.setDatum("engineeringDatum", value);
    }

    @XmlElement(name="affineCS")
    private AffineCS getAffineCS() {
        return this.getCoordinateSystem(AffineCS.class);
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    @XmlElement(name="cylindricalCS")
    private CylindricalCS getCylindricalCS() {
        return this.getCoordinateSystem(CylindricalCS.class);
    }

    @XmlElement(name="linearCS")
    private LinearCS getLinearCS() {
        return this.getCoordinateSystem(LinearCS.class);
    }

    @XmlElement(name="polarCS")
    private PolarCS getPolarCS() {
        return this.getCoordinateSystem(PolarCS.class);
    }

    @XmlElement(name="sphericalCS")
    private SphericalCS getSphericalCS() {
        return this.getCoordinateSystem(SphericalCS.class);
    }

    @Deprecated(since="1.5")
    @XmlElement(name="userDefinedCS")
    private UserDefinedCS getUserDefinedCS() {
        return this.getCoordinateSystem(UserDefinedCS.class);
    }

    private void setAffineCS(AffineCS cs) {
        super.setCoordinateSystem("affineCS", (CoordinateSystem)cs);
    }

    private void setCartesianCS(CartesianCS cs) {
        super.setCoordinateSystem("cartesianCS", (CoordinateSystem)cs);
    }

    private void setCylindricalCS(CylindricalCS cs) {
        super.setCoordinateSystem("cylindricalCS", (CoordinateSystem)cs);
    }

    private void setLinearCS(LinearCS cs) {
        super.setCoordinateSystem("linearCS", (CoordinateSystem)cs);
    }

    private void setPolarCS(PolarCS cs) {
        super.setCoordinateSystem("polarCS", (CoordinateSystem)cs);
    }

    private void setSphericalCS(SphericalCS cs) {
        super.setCoordinateSystem("sphericalCS", (CoordinateSystem)cs);
    }

    @Deprecated(since="1.5")
    private void setUserDefinedCS(UserDefinedCS cs) {
        super.setCoordinateSystem("userDefinedCS", (CoordinateSystem)cs);
    }

    @XmlElement(name="coordinateSystem", required=true)
    @XmlJavaTypeAdapter(value=CS_CoordinateSystem.class)
    private CoordinateSystem getAbstractCS() {
        CoordinateSystem cs = this.getCoordinateSystem();
        for (Class<?> t : SPECIALIZED_TYPES) {
            if (!t.isInstance(cs)) continue;
            return null;
        }
        return cs;
    }

    private void setAbstractCS(CoordinateSystem cs) {
        this.setCoordinateSystem(null, cs);
    }
}

