/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntFunction;
import org.apache.sis.util.ArraysExt;

public abstract class SetOfUnknownSize<E>
extends AbstractSet<E> {
    static final int DEFAULT_INITIAL_SIZE = 16;

    protected SetOfUnknownSize() {
    }

    @Override
    public boolean isEmpty() {
        return this.sizeIfKnown().orElseGet(() -> this.iterator().hasNext() ? 1 : 0) == 0;
    }

    @Override
    public int size() {
        return this.sizeIfKnown().orElseGet(() -> {
            int count = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                it.next();
                if (++count != Integer.MAX_VALUE) continue;
                break;
            }
            return count;
        });
    }

    protected OptionalInt sizeIfKnown() {
        return OptionalInt.empty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            modified |= this.remove(it.next());
        }
        return modified;
    }

    protected int characteristics() {
        return 1;
    }

    @Override
    public Spliterator<E> spliterator() {
        int characteristics = this.characteristics();
        OptionalInt size = this.sizeIfKnown();
        return size.isPresent() ? Spliterators.spliterator(this.iterator(), (long)size.getAsInt(), characteristics) : Spliterators.spliteratorUnknownSize(this.iterator(), characteristics);
    }

    @Override
    public Object[] toArray() {
        return SetOfUnknownSize.toArray(this.iterator(), new Object[this.sizeIfKnown().orElse(16)], true);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return SetOfUnknownSize.toArray(this.iterator(), array, false);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return SetOfUnknownSize.toArray(this.iterator(), generator.apply(this.sizeIfKnown().orElse(16)), true);
    }

    static <E> E[] toArray(Iterator<?> it, E[] array, boolean trimToSize) {
        int i = 0;
        while (it.hasNext()) {
            if (i >= array.length) {
                int length = array.length << 1;
                if (length < 0 && (length = Integer.MAX_VALUE) == array.length) break;
                array = Arrays.copyOf(array, Math.max(16, length));
                trimToSize = true;
            }
            array[i++] = it.next();
        }
        if (trimToSize) {
            array = ArraysExt.resize(array, i);
        } else {
            Arrays.fill(array, i, array.length, null);
        }
        return array;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        int size = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!that.contains(it.next())) {
                return false;
            }
            ++size;
        }
        return size == that.size();
    }
}

