/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.internal.shared.AffineTransform2D;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.provider.PseudoPlateCarree;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.netcdf.base.CRSMerger;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.NamedElement;
import org.apache.sis.storage.netcdf.base.Node;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class GridMapping {
    private static final String CRS_WKT = "crs_wkt";
    private static final String SPATIAL_REF = "spatial_ref";
    private final Node mapping;
    private CoordinateReferenceSystem crs;
    private MathTransform gridToCRS;
    private boolean isWKT;

    private GridMapping(Node mapping) {
        this.mapping = mapping;
    }

    static GridMapping forVariable(Variable variable) {
        Map<String, GridMapping> gridMapping = variable.decoder.gridMapping;
        for (String name : variable.decoder.convention().nameOfMappingNode(variable)) {
            GridMapping gm = gridMapping.get(name);
            if (gm != null) {
                return gm;
            }
            if (gridMapping.containsKey(name)) continue;
            Node mapping = variable.decoder.findNode(name);
            if (mapping != null) {
                gm = GridMapping.parse(mapping);
            }
            gridMapping.put(name, gm);
            if (gm == null) continue;
            return gm;
        }
        String name = variable.getName();
        GridMapping gm = gridMapping.get(name);
        if (gm == null && !gridMapping.containsKey(name)) {
            gm = GridMapping.parse(variable);
            gridMapping.put(name, gm);
        }
        return gm;
    }

    private static GridMapping parse(Node mapping) {
        GridMapping gm = new GridMapping(mapping);
        return gm.parseProjectionParameters() || gm.parseGeoTransform() || gm.parseESRI() ? gm : null;
    }

    private boolean parseProjectionParameters() {
        Map<String, Object> definition = this.mapping.decoder.convention().projection(this.mapping);
        if (definition != null) {
            try {
                LinearTransform baseToCRS;
                Object greenwichLongitude = definition.remove("longitude_of_prime_meridian");
                String mappingName = (String)definition.remove("grid_mapping_name");
                OperationMethod method = this.mapping.decoder.findOperationMethod(mappingName);
                ParameterValueGroup parameters = method.getParameters().createValue();
                Iterator<Map.Entry<String, Object>> it = definition.entrySet().iterator();
                block15: while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    String name = entry.getKey();
                    Object value = entry.getValue();
                    try {
                        ParameterValue parameter;
                        if (value instanceof Number || value instanceof double[] || value instanceof float[]) {
                            it.remove();
                            parameters.parameter(name).setValue(value);
                            continue;
                        }
                        if (!(value instanceof String)) continue;
                        String text = (String)value;
                        if (name.endsWith("_name")) continue;
                        switch (name) {
                            case "crs_wkt": 
                            case "spatial_ref": {
                                continue block15;
                            }
                            case "geotransform": {
                                if (!this.parseGeoTransform(null, text)) continue block15;
                                it.remove();
                                continue block15;
                            }
                        }
                        try {
                            parameter = parameters.parameter(name);
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                        Class type = parameter.getDescriptor().getValueClass();
                        if (Numbers.isNumber((Class)type)) {
                            it.remove();
                            parameter.setValue(Double.parseDouble(text));
                            continue;
                        }
                        if (!Numbers.isNumber(type.getComponentType())) continue;
                        it.remove();
                        parameter.setValue(GridMapping.parseDoubles(text), null);
                    }
                    catch (IllegalArgumentException ex) {
                        GridMapping.warning(this.mapping, ex, null, (short)20, this.mapping.decoder.getFilename(), this.mapping.getName(), name, value, ex.getLocalizedMessage());
                    }
                }
                boolean geographic = method instanceof PseudoPlateCarree;
                GeographicCRS baseCRS = GridMapping.createBaseCRS(this.mapping.decoder, parameters, definition, greenwichLongitude, geographic);
                if (geographic) {
                    baseToCRS = MathTransforms.linear((Matrix)new Matrix3(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
                    this.crs = baseCRS;
                } else {
                    DefaultCoordinateOperationFactory opFactory = this.mapping.decoder.getCoordinateOperationFactory();
                    Map<String, Object> properties = GridMapping.properties(definition, "conversion_name", false, this.mapping.getName());
                    Conversion conversion = opFactory.createDefiningConversion(properties, method, parameters);
                    CartesianCS cs = this.mapping.decoder.getStandardProjectedCS();
                    properties = GridMapping.properties(definition, "projected_crs_name", true, conversion);
                    ProjectedCRS p = this.mapping.decoder.getCRSFactory().createProjectedCRS(properties, baseCRS, conversion, cs);
                    baseToCRS = p.getConversionFromBase().getMathTransform();
                    this.crs = p;
                }
                ArrayList<String> done = new ArrayList<String>(2);
                this.setOrVerifyWKT(definition, CRS_WKT, done);
                this.setOrVerifyWKT(definition, SPATIAL_REF, done);
                definition.remove("long_name");
                if (!definition.isEmpty()) {
                    GridMapping.warningInMapping(this.mapping, null, (short)25, String.join((CharSequence)", ", definition.keySet()));
                }
                this.gridToCRS = this.gridToCRS == null ? this.mapping.decoder.convention().gridToCRS(this.mapping, (MathTransform)baseToCRS) : MathTransforms.concatenate((MathTransform)this.gridToCRS, (MathTransform)baseToCRS);
                return true;
            }
            catch (ClassCastException | IllegalArgumentException | TransformException | FactoryException e) {
                GridMapping.warningInMapping(this.mapping, (Exception)e, (short)11, null);
            }
        }
        return false;
    }

    private static GeographicCRS createBaseCRS(Decoder decoder, ParameterValueGroup parameters, Map<String, Object> definition, Object greenwichLongitude, boolean main) throws FactoryException {
        GeodeticDatum datum;
        Ellipsoid ellipsoid;
        PrimeMeridian meridian;
        DatumFactory datumFactory = decoder.getDatumFactory();
        CommonCRS defaultDefinitions = decoder.convention().defaultHorizontalCRS(false);
        boolean isSpecified = false;
        if (greenwichLongitude instanceof Number) {
            double longitude = ((Number)greenwichLongitude).doubleValue();
            String name = longitude == 0.0 ? "Greenwich" : null;
            Map<String, Object> properties = GridMapping.properties(definition, "prime_meridian_name", false, name);
            meridian = datumFactory.createPrimeMeridian(properties, longitude, Units.DEGREE);
            isSpecified = true;
        } else {
            meridian = defaultDefinitions.primeMeridian();
        }
        try {
            double secondDefiningParameter;
            ParameterValue p = parameters.parameter("semi_major");
            Unit axisUnit = p.getUnit().asType(Length.class);
            double semiMajor = p.doubleValue();
            boolean isIvfDefinitive = parameters.parameter("is_ivf_definitive").booleanValue();
            boolean isSphere = isIvfDefinitive ? (secondDefiningParameter = parameters.parameter("inverse_flattening").doubleValue()) == 0.0 || Double.isInfinite(secondDefiningParameter) : (secondDefiningParameter = parameters.parameter("semi_minor").doubleValue(axisUnit)) == semiMajor;
            Supplier<Object> fallback = () -> {
                Locale locale = decoder.listeners.getLocale();
                NumberFormat f = NumberFormat.getNumberInstance(locale);
                f.setMaximumFractionDigits(5);
                double km = axisUnit.getConverterTo(Units.KILOMETRE).convert(semiMajor);
                StringBuffer b = new StringBuffer().append(Vocabulary.forLocale((Locale)locale).getString(isSphere ? (short)271 : (short)72)).append(isSphere ? " R=" : " a=");
                return f.format(km, b, new FieldPosition(0)).append(" km").toString();
            };
            Map<String, Object> properties = GridMapping.properties(definition, "reference_ellipsoid_name", false, fallback);
            ellipsoid = isIvfDefinitive ? datumFactory.createFlattenedSphere(properties, semiMajor, secondDefiningParameter, axisUnit) : datumFactory.createEllipsoid(properties, semiMajor, secondDefiningParameter, axisUnit);
            isSpecified = true;
        }
        catch (IllegalStateException | ParameterNotFoundException e) {
            ellipsoid = defaultDefinitions.ellipsoid();
        }
        Object bursaWolf = definition.remove("towgs84");
        if (isSpecified | bursaWolf != null) {
            Map<String, Object> properties = GridMapping.properties(definition, "horizontal_datum_name", false, ellipsoid);
            if (bursaWolf instanceof BursaWolfParameters) {
                properties = new HashMap<String, Object>(properties);
                properties.put("bursaWolf", bursaWolf);
                isSpecified = true;
            }
            datum = datumFactory.createGeodeticDatum(properties, ellipsoid, meridian);
        } else {
            datum = DatumOrEnsemble.asDatum((GeodeticCRS)defaultDefinitions.geographic());
        }
        if (isSpecified) {
            Map<String, Object> properties = GridMapping.properties(definition, "geographic_crs_name", main, datum);
            return decoder.getCRSFactory().createGeographicCRS(properties, datum, defaultDefinitions.geographic().getCoordinateSystem());
        }
        return defaultDefinitions.geographic();
    }

    private static Map<String, Object> properties(Map<String, Object> definition, String nameAttribute, boolean takeComment, Object fallback) {
        Object comment;
        Object name = definition.remove(nameAttribute);
        if (name == null) {
            name = fallback == null ? Vocabulary.format((short)208) : (fallback instanceof IdentifiedObject ? ((IdentifiedObject)fallback).getName() : (fallback instanceof Supplier ? ((Supplier)fallback).get() : fallback.toString()));
        }
        if (takeComment && (comment = definition.remove("comment")) != null) {
            return Map.of("name", name, "remarks", comment.toString());
        }
        return Map.of("name", name);
    }

    private void setOrVerifyWKT(Map<String, Object> definition, String attributeName, List<String> done) {
        Object value = definition.remove(attributeName);
        if (value instanceof String) {
            CoordinateReferenceSystem check;
            String wkt = ((String)value).strip();
            for (String previous : done) {
                if (!wkt.equalsIgnoreCase(previous)) continue;
                return;
            }
            done.add(wkt);
            try {
                check = this.createFromWKT((String)value);
            }
            catch (Exception e) {
                GridMapping.warning(this.mapping, e, (IndexedResourceBundle)this.mapping.errors(), (short)155, attributeName);
                return;
            }
            if (this.crs == null) {
                this.crs = check;
            } else if (!Utilities.deepEquals((Object)this.crs, (Object)check, (ComparisonMode)ComparisonMode.ALLOW_VARIANT)) {
                GridMapping.warning(this.mapping, null, null, (short)29, this.mapping.decoder.getFilename(), this.mapping.getName());
            }
        }
    }

    private boolean parseGeoTransform() {
        return this.parseGeoTransform(this.mapping.getAttributeAsString(SPATIAL_REF), this.mapping.getAttributeAsString("GeoTransform"));
    }

    private boolean parseGeoTransform(String wkt, String gtr) {
        short message = 11;
        boolean done = false;
        try {
            if (wkt != null) {
                this.crs = this.createFromWKT(wkt);
                this.isWKT = true;
                done = true;
            }
            if (gtr != null) {
                message = 12;
                double[] c = GridMapping.parseDoubles(gtr);
                if (c.length != 6) {
                    throw new DataStoreContentException(this.mapping.errors().getString((short)164, (Object)6, (Object)c.length));
                }
                this.gridToCRS = new AffineTransform2D(c[1], c[4], c[2], c[5], c[0], c[3]);
                done = true;
            }
        }
        catch (Exception e) {
            GridMapping.warningInMapping(this.mapping, e, message, null);
        }
        return done;
    }

    private static double[] parseDoubles(String values) {
        return CharSequences.parseDoubles((CharSequence)values.replace(',', ' '), (char)' ');
    }

    private boolean parseESRI() {
        String code = this.mapping.getAttributeAsString("ESRI_pe_string");
        boolean bl = this.isWKT = code != null;
        if (code == null && (code = this.mapping.getAttributeAsString("EPSG_code")) == null) {
            return false;
        }
        try {
            this.crs = this.isWKT ? this.createFromWKT(code) : CRS.forCode((String)("EPSG:" + code));
        }
        catch (Exception e) {
            GridMapping.warningInMapping(this.mapping, e, (short)11, null);
            return false;
        }
        return true;
    }

    private CoordinateReferenceSystem createFromWKT(String wkt) throws ParseException {
        WKTFormat f = new WKTFormat(Decoder.DATA_LOCALE, (ZoneId)this.mapping.decoder.getTimeZone());
        f.setConvention(Convention.WKT1_COMMON_UNITS);
        CoordinateReferenceSystem parsed = (CoordinateReferenceSystem)f.parseObject(wkt);
        Warnings warnings = f.getWarnings();
        if (warnings != null) {
            LogRecord record = new LogRecord(Level.WARNING, warnings.toString());
            record.setLoggerName("org.apache.sis.storage.netcdf");
            record.setSourceClassName(Variable.class.getName());
            record.setSourceMethodName("getGridGeometry");
            this.mapping.decoder.listeners.warning(record);
        }
        return parsed;
    }

    private static void warningInMapping(Node mapping, Exception ex, short key, String more) {
        if (more == null) {
            more = ex.getLocalizedMessage();
        }
        GridMapping.warning(mapping, ex, null, key, mapping.decoder.getFilename(), mapping.getName(), more);
    }

    private static void warning(Node mapping, Exception ex, IndexedResourceBundle resources, short key, Object ... arguments) {
        NamedElement.warning(mapping.decoder.listeners, Variable.class, "getGridGeometry", ex, resources, key, arguments);
    }

    final CoordinateReferenceSystem crs() {
        return this.crs;
    }

    final GridGeometry createGridCRS(Variable variable) {
        List<Dimension> dimensions = variable.getGridDimensions();
        int srcDim = dimensions.size();
        long[] upper = new long[srcDim];
        for (int i = 0; i < srcDim; ++i) {
            int d = srcDim - 1 - i;
            upper[i] = dimensions.get(d).length();
        }
        MathTransform implicitG2C = this.gridToCRS;
        CoordinateReferenceSystem implicitCRS = this.crs;
        if (implicitG2C != null) {
            implicitG2C = MathTransforms.concatenate((MathTransform)GridMapping.changeOfDimension(srcDim, implicitG2C.getSourceDimensions()), (MathTransform)implicitG2C, (MathTransform)GridMapping.changeOfDimension(implicitG2C.getTargetDimensions(), ReferencingUtilities.getDimension((CoordinateReferenceSystem)implicitCRS)));
        }
        GridExtent extent = new GridExtent(null, null, upper, false);
        return new GridGeometry(extent, PixelInCell.CELL_CENTER, implicitG2C, implicitCRS);
    }

    private static MathTransform changeOfDimension(int srcDim, int tgtDim) {
        if (tgtDim == srcDim || tgtDim == 0) {
            return MathTransforms.identity((int)srcDim);
        }
        return MathTransforms.linear((Matrix)Matrices.createDimensionSelect((int)srcDim, (int[])ArraysExt.range((int)0, (int)tgtDim)));
    }

    final GridGeometry adaptGridCRS(Variable variable, GridGeometry implicit, PixelInCell anchor) {
        CoordinateReferenceSystem explicitCRS = this.crs;
        int firstAffectedCoordinate = 0;
        boolean isSameGrid = true;
        if (implicit.isDefined(1)) {
            CoordinateReferenceSystem implicitCRS = implicit.getCoordinateReferenceSystem();
            if (explicitCRS == null) {
                explicitCRS = implicitCRS;
            } else {
                CoordinateSystem cs = implicitCRS.getCoordinateSystem();
                firstAffectedCoordinate = AxisDirections.indexOfColinear((CoordinateSystem)cs, (CoordinateSystem)explicitCRS.getCoordinateSystem());
                if (firstAffectedCoordinate < 0 && (firstAffectedCoordinate = AxisDirections.indexOfColinear((CoordinateSystem)cs, (CoordinateSystem)(explicitCRS = AbstractCRS.castOrCopy((CoordinateReferenceSystem)explicitCRS).forConvention(AxesConvention.RIGHT_HANDED)).getCoordinateSystem())) < 0) {
                    firstAffectedCoordinate = 0;
                    if (this.isWKT && this.crs != null) {
                        explicitCRS = this.crs;
                    }
                }
                try {
                    explicitCRS = new CRSMerger(variable.decoder).replaceComponent(implicitCRS, firstAffectedCoordinate, explicitCRS);
                }
                catch (FactoryException e) {
                    GridMapping.warningInMapping(variable, (Exception)((Object)e), (short)11, null);
                    return null;
                }
                isSameGrid = implicitCRS.equals((Object)explicitCRS);
                if (isSameGrid) {
                    explicitCRS = implicitCRS;
                }
            }
        }
        MathTransform explicitG2C = this.gridToCRS;
        if (implicit.isDefined(8)) {
            MathTransform implicitG2C = implicit.getGridToCRS(anchor);
            if (explicitG2C == null) {
                explicitG2C = implicitG2C;
            } else {
                try {
                    int upper;
                    int count = 0;
                    Object[] components = new MathTransform[3];
                    TransformSeparator sep = new TransformSeparator(implicitG2C, variable.decoder.getMathTransformFactory());
                    if (firstAffectedCoordinate != 0) {
                        sep.addTargetDimensionRange(0, firstAffectedCoordinate);
                        components[count++] = sep.separate();
                        sep.clear();
                    }
                    components[count++] = explicitG2C;
                    int next = firstAffectedCoordinate + explicitG2C.getTargetDimensions();
                    if (next != (upper = implicitG2C.getTargetDimensions())) {
                        sep.addTargetDimensionRange(next, upper);
                        components[count++] = sep.separate();
                    }
                    if (implicitG2C.equals((Object)(explicitG2C = MathTransforms.compound((MathTransform[])(components = (MathTransform[])ArraysExt.resize((Object[])components, (int)count)))))) {
                        explicitG2C = implicitG2C;
                    } else {
                        isSameGrid = false;
                    }
                }
                catch (FactoryException e) {
                    GridMapping.warningInMapping(variable, (Exception)((Object)e), (short)12, null);
                    return null;
                }
            }
        }
        if (isSameGrid) {
            return implicit;
        }
        return new GridGeometry(implicit.getExtent(), anchor, explicitG2C, explicitCRS);
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{null, this.mapping.getName(), "crs", IdentifiedObjects.getName((IdentifiedObject)this.crs, null), "isWKT", this.isWKT});
    }
}

