/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.BinaryString;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class SymbolTypeConstructor
extends VariableWidthTypeConstructor<Symbol> {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final ConcurrentMap<BinaryString, Symbol> SYMBOL_MAP = new ConcurrentHashMap<BinaryString, Symbol>(2048);

    public static SymbolTypeConstructor getInstance(int i) {
        return new SymbolTypeConstructor(i);
    }

    private SymbolTypeConstructor(int size) {
        super(size);
    }

    @Override
    public Symbol construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (!in.hasRemaining(this.getSize())) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct symbol: insufficient input data", new Object[0]);
        }
        int size = this.getSize() == 1 ? in.getUnsignedByte() : in.getInt();
        if (!in.hasRemaining(size)) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct symbol: insufficient input data", new Object[0]);
        }
        byte[] data = new byte[size];
        in.get(data);
        BinaryString binaryStr = new BinaryString(data);
        Symbol symbolVal = (Symbol)SYMBOL_MAP.get(binaryStr);
        if (symbolVal == null) {
            symbolVal = Symbol.valueOf(new String(data, ASCII));
            SYMBOL_MAP.putIfAbsent(binaryStr, symbolVal);
        }
        return symbolVal;
    }
}

