/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.DecodeOptions;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;

public class PDStream
implements COSObjectable {
    private static final Log LOG = LogFactory.getLog(PDStream.class);
    private final COSStream stream;

    public PDStream(PDDocument document) {
        this.stream = document.getDocument().createCOSStream();
    }

    public PDStream(COSDocument document) {
        this.stream = document.createCOSStream();
    }

    public PDStream(COSStream str) {
        this.stream = str;
    }

    public PDStream(PDDocument doc, InputStream input) throws IOException {
        this(doc, input, (COSBase)null);
    }

    public PDStream(PDDocument doc, InputStream input, COSName filter) throws IOException {
        this(doc, input, (COSBase)filter);
    }

    public PDStream(PDDocument doc, InputStream input, COSArray filters) throws IOException {
        this(doc, input, (COSBase)filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDStream(PDDocument doc, InputStream input, COSBase filters) throws IOException {
        this.stream = doc.getDocument().createCOSStream();
        try (OutputStream output = this.stream.createOutputStream(filters);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        finally {
            input.close();
        }
    }

    @Override
    public COSStream getCOSObject() {
        return this.stream;
    }

    public OutputStream createOutputStream() throws IOException {
        return this.stream.createOutputStream();
    }

    public OutputStream createOutputStream(COSName filter) throws IOException {
        return this.stream.createOutputStream(filter);
    }

    public COSInputStream createInputStream() throws IOException {
        return this.stream.createInputStream();
    }

    public COSInputStream createInputStream(DecodeOptions options) throws IOException {
        return this.stream.createInputStream(options);
    }

    public InputStream createInputStream(List<String> stopFilters) throws IOException {
        if (stopFilters == null) {
            stopFilters = Collections.emptyList();
        }
        InputStream is = this.stream.createRawInputStream();
        ArrayList<Filter> someFilters = new ArrayList<Filter>();
        List<COSName> filters = this.getFilters();
        for (COSName nextFilter : filters) {
            if (stopFilters.contains(nextFilter.getName())) break;
            someFilters.add(FilterFactory.INSTANCE.getFilter(nextFilter));
        }
        if (someFilters.isEmpty()) {
            return is;
        }
        RandomAccessRead decoded = Filter.decode(is, someFilters, this.getCOSObject(), DecodeOptions.DEFAULT, null);
        return new RandomAccessInputStream(decoded);
    }

    public int getLength() {
        return this.stream.getInt(COSName.LENGTH, 0);
    }

    public List<COSName> getFilters() {
        COSBase filters = this.stream.getFilters();
        if (filters instanceof COSName) {
            return Collections.singletonList((COSName)filters);
        }
        if (filters instanceof COSArray) {
            return ((COSArray)filters).toList();
        }
        return Collections.emptyList();
    }

    public void setFilters(List<COSName> filters) {
        this.stream.setItem(COSName.FILTER, (COSBase)new COSArray(filters));
    }

    public List<Object> getDecodeParms() throws IOException {
        return this.internalGetDecodeParams(COSName.DECODE_PARMS, COSName.DP);
    }

    public List<Object> getFileDecodeParams() throws IOException {
        return this.internalGetDecodeParams(COSName.F_DECODE_PARMS, null);
    }

    private List<Object> internalGetDecodeParams(COSName name1, COSName name2) throws IOException {
        COSBase dp = this.stream.getDictionaryObject(name1, name2);
        if (dp instanceof COSDictionary) {
            COSDictionaryMap<String, Object> map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            return new COSArrayList<Object>(map, dp, this.stream, name1);
        }
        if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap<String, Object>> actuals = new ArrayList<COSDictionaryMap<String, Object>>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                COSBase base = array.getObject(i);
                if (base instanceof COSDictionary) {
                    actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)base));
                    continue;
                }
                LOG.warn((Object)("Expected COSDictionary, got " + base + ", ignored"));
            }
            return new COSArrayList<Object>(actuals, array);
        }
        return null;
    }

    public void setDecodeParms(List<?> decodeParams) {
        this.stream.setItem(COSName.DECODE_PARMS, (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    public PDFileSpecification getFile() throws IOException {
        COSBase f = this.stream.getDictionaryObject(COSName.F);
        return PDFileSpecification.createFS(f);
    }

    public void setFile(PDFileSpecification f) {
        this.stream.setItem(COSName.F, (COSObjectable)f);
    }

    public List<String> getFileFilters() {
        COSBase filters = this.stream.getDictionaryObject(COSName.F_FILTER);
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            return Collections.singletonList(name.getName());
        }
        if (filters instanceof COSArray) {
            return ((COSArray)filters).toCOSNameStringList();
        }
        return Collections.emptyList();
    }

    public void setFileFilters(List<String> filters) {
        COSArray obj = COSArray.ofCOSNames(filters);
        this.stream.setItem(COSName.F_FILTER, (COSBase)obj);
    }

    public void setFileDecodeParams(List<?> decodeParams) {
        this.stream.setItem(COSName.F_DECODE_PARMS, (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    public byte[] toByteArray() throws IOException {
        try (COSInputStream is = this.createInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSBase mdStream = this.stream.getDictionaryObject(COSName.METADATA);
        if (mdStream instanceof COSStream) {
            retval = new PDMetadata((COSStream)mdStream);
        } else if (!(mdStream instanceof COSNull) && mdStream != null) {
            throw new IllegalStateException("Expected a COSStream but was a " + mdStream.getClass().getSimpleName());
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.stream.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getDecodedStreamLength() {
        return this.stream.getInt(COSName.DL);
    }

    public void setDecodedStreamLength(int decodedStreamLength) {
        this.stream.setInt(COSName.DL, decodedStreamLength);
    }
}

