/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.action;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.action.AbstractActionManager;
import org.apache.pdfbox.preflight.action.ActionManagerFactory;
import org.apache.pdfbox.preflight.utils.COSUtils;

public class HideAction
extends AbstractActionManager {
    public HideAction(ActionManagerFactory amFact, COSDictionary adict, PreflightContext ctx, String aaKey) {
        super(amFact, adict, ctx, aaKey);
    }

    @Override
    protected boolean innerValid() {
        COSBase t = this.actionDictionnary.getItem(COSName.T);
        if (t == null) {
            this.context.addValidationError(new ValidationResult.ValidationError("6.1.1", "T entry is mandatory for the NamedActions"));
            return false;
        }
        COSDocument cosDocument = this.context.getDocument().getDocument();
        if (!(COSUtils.isDictionary(t, cosDocument) || COSUtils.isArray(t, cosDocument) || COSUtils.isString(t, cosDocument))) {
            this.context.addValidationError(new ValidationResult.ValidationError("6.1.3", "T entry type is invalid"));
            return false;
        }
        boolean h = this.actionDictionnary.getBoolean(COSName.H, true);
        if (h) {
            this.context.addValidationError(new ValidationResult.ValidationError("6.1.4", "H entry is \"true\""));
            return false;
        }
        return true;
    }
}

