/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.Option;
import com.hazelcast.internal.tpcengine.net.AsyncSocketOptions;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import jdk.net.ExtendedSocketOptions;

public class NioAsyncSocketOptions
implements AsyncSocketOptions {
    private final SocketChannel socketChannel;
    private final Map<Option, Object> extraOptions = new HashMap<Option, Object>();

    NioAsyncSocketOptions(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    private static SocketOption toSocketOption(Option option) {
        if (TCP_NODELAY.equals(option)) {
            return StandardSocketOptions.TCP_NODELAY;
        }
        if (SO_RCVBUF.equals(option)) {
            return StandardSocketOptions.SO_RCVBUF;
        }
        if (SO_SNDBUF.equals(option)) {
            return StandardSocketOptions.SO_SNDBUF;
        }
        if (SO_KEEPALIVE.equals(option)) {
            return StandardSocketOptions.SO_KEEPALIVE;
        }
        if (SO_REUSEADDR.equals(option)) {
            return StandardSocketOptions.SO_REUSEADDR;
        }
        if (TCP_KEEPCOUNT.equals(option)) {
            return ExtendedSocketOptions.TCP_KEEPCOUNT;
        }
        if (TCP_KEEPINTERVAL.equals(option)) {
            return ExtendedSocketOptions.TCP_KEEPINTERVAL;
        }
        if (TCP_KEEPIDLE.equals(option)) {
            return ExtendedSocketOptions.TCP_KEEPIDLE;
        }
        return null;
    }

    @Override
    public boolean isSupported(Option option) {
        Preconditions.checkNotNull(option, "option");
        return this.isSupported(NioAsyncSocketOptions.toSocketOption(option)) || SSL_ENGINE_FACTORY.equals(option) || TLS_EXECUTOR.equals(option);
    }

    private boolean isSupported(SocketOption socketOption) {
        return socketOption != null && this.socketChannel.supportedOptions().contains(socketOption);
    }

    @Override
    public <T> T get(Option<T> option) {
        Preconditions.checkNotNull(option, "option");
        try {
            if (!this.isSupported(option)) {
                return null;
            }
            SocketOption socketOption = NioAsyncSocketOptions.toSocketOption(option);
            if (this.isSupported(socketOption)) {
                return this.socketChannel.getOption(socketOption);
            }
            return (T)this.extraOptions.get(option);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public <T> boolean set(Option<T> option, T value) {
        Preconditions.checkNotNull(option, "option");
        Preconditions.checkNotNull(value, "value");
        try {
            if (!this.isSupported(option)) {
                return false;
            }
            SocketOption socketOption = NioAsyncSocketOptions.toSocketOption(option);
            if (this.isSupported(socketOption)) {
                this.socketChannel.setOption(socketOption, (Object)value);
                return true;
            }
            this.extraOptions.put(option, value);
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

