/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.config.CompactSerializationConfigAccessor;
import com.hazelcast.config.ConfigXmlGenerator;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ConfigXmlGeneratorHelper {
    private ConfigXmlGeneratorHelper() {
    }

    public static void compactSerialization(ConfigXmlGenerator.XmlGenerator gen, CompactSerializationConfig config) {
        gen.open("compact-serialization", new Object[0]);
        Map<String, TriTuple<Class, String, CompactSerializer>> registrations = CompactSerializationConfigAccessor.getRegistrations(config);
        List<String> programmaticSerializerClassNames = ConfigXmlGeneratorHelper.getProgrammaticCompactSerializerClassNames(registrations);
        List<String> programmaticCompactSerializableClassNames = ConfigXmlGeneratorHelper.getProgrammaticCompactSerializableClassNames(registrations);
        List<String> serializerClassNames = CompactSerializationConfigAccessor.getSerializerClassNames(config);
        List<String> compactSerializableClassNames = CompactSerializationConfigAccessor.getCompactSerializableClassNames(config);
        if (!ConfigXmlGeneratorHelper.isNullOrEmpty(serializerClassNames) || !ConfigXmlGeneratorHelper.isNullOrEmpty(programmaticSerializerClassNames)) {
            gen.open("serializers", new Object[0]);
            ConfigXmlGeneratorHelper.appendCompactSerializerClassNames(gen, serializerClassNames);
            ConfigXmlGeneratorHelper.appendCompactSerializerClassNames(gen, programmaticSerializerClassNames);
            gen.close();
        }
        if (!ConfigXmlGeneratorHelper.isNullOrEmpty(compactSerializableClassNames) || !ConfigXmlGeneratorHelper.isNullOrEmpty(programmaticCompactSerializableClassNames)) {
            gen.open("classes", new Object[0]);
            ConfigXmlGeneratorHelper.appendCompactSerializableClassNames(gen, compactSerializableClassNames);
            ConfigXmlGeneratorHelper.appendCompactSerializableClassNames(gen, programmaticCompactSerializableClassNames);
            gen.close();
        }
        gen.close();
    }

    private static void appendCompactSerializerClassNames(ConfigXmlGenerator.XmlGenerator gen, List<String> classNames) {
        if (ConfigXmlGeneratorHelper.isNullOrEmpty(classNames)) {
            return;
        }
        classNames.forEach(className -> gen.node("serializer", className, new Object[0]));
    }

    private static void appendCompactSerializableClassNames(ConfigXmlGenerator.XmlGenerator gen, List<String> classNames) {
        if (ConfigXmlGeneratorHelper.isNullOrEmpty(classNames)) {
            return;
        }
        classNames.forEach(className -> gen.node("class", className, new Object[0]));
    }

    private static List<String> getProgrammaticCompactSerializerClassNames(Map<String, TriTuple<Class, String, CompactSerializer>> registrations) {
        if (MapUtil.isNullOrEmpty(registrations)) {
            return null;
        }
        return registrations.values().stream().filter(registration -> registration.element3 != null).map(registration -> ((CompactSerializer)registration.element3).getClass().getName()).collect(Collectors.toList());
    }

    private static List<String> getProgrammaticCompactSerializableClassNames(Map<String, TriTuple<Class, String, CompactSerializer>> registrations) {
        if (MapUtil.isNullOrEmpty(registrations)) {
            return null;
        }
        return registrations.values().stream().filter(registration -> registration.element3 == null).map(registration -> ((Class)registration.element1).getName()).collect(Collectors.toList());
    }

    private static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }
}

