/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.dynamicconfig;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddWanReplicationConfigCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.AbstractAddConfigMessageTask;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.WanReplicationConfigTransformer;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.dynamicconfig.DynamicConfigurationAwareConfig;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AddWanReplicationConfigTask
extends AbstractAddConfigMessageTask<DynamicConfigAddWanReplicationConfigCodec.RequestParameters> {
    public AddWanReplicationConfigTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected DynamicConfigAddWanReplicationConfigCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return DynamicConfigAddWanReplicationConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return DynamicConfigAddWanReplicationConfigCodec.encodeResponse();
    }

    @Override
    public String getMethodName() {
        return "addWanReplicationConfig";
    }

    @Override
    protected IdentifiedDataSerializable getConfig() {
        WanReplicationConfigTransformer transformer = new WanReplicationConfigTransformer(this.serializationService);
        WanConsumerConfig wanConsumerConfig = transformer.toConfig(((DynamicConfigAddWanReplicationConfigCodec.RequestParameters)this.parameters).consumerConfig);
        List<WanCustomPublisherConfig> customPublisherConfigs = ((DynamicConfigAddWanReplicationConfigCodec.RequestParameters)this.parameters).customPublisherConfigs.stream().filter(Objects::nonNull).map(transformer::toConfig).collect(Collectors.toList());
        List<WanBatchPublisherConfig> batchPublisherConfigs = ((DynamicConfigAddWanReplicationConfigCodec.RequestParameters)this.parameters).batchPublisherConfigs.stream().filter(Objects::nonNull).map(transformer::toConfig).collect(Collectors.toList());
        WanReplicationConfig config = new WanReplicationConfig();
        config.setName(((DynamicConfigAddWanReplicationConfigCodec.RequestParameters)this.parameters).name);
        if (wanConsumerConfig != null) {
            config.setConsumerConfig(wanConsumerConfig);
        }
        config.setCustomPublisherConfigs(customPublisherConfigs);
        config.setBatchPublisherConfigs(batchPublisherConfigs);
        return config;
    }

    @Override
    protected boolean checkStaticConfigDoesNotExist(IdentifiedDataSerializable config) {
        DynamicConfigurationAwareConfig nodeConfig = (DynamicConfigurationAwareConfig)this.nodeEngine.getConfig();
        WanReplicationConfig wanReplicationConfig = (WanReplicationConfig)config;
        return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(nodeConfig.getStaticConfig().getWanReplicationConfigs(), wanReplicationConfig.getName(), wanReplicationConfig);
    }
}

