/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.wan;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.wan.impl.WanDataSerializerHook;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WanCacheEntryView<K, V>
implements CacheEntryView<K, V>,
IdentifiedDataSerializable,
SerializationServiceAware {
    private SerializationService serializationService;
    private K key;
    private V value;
    private Data dataKey;
    private Data dataValue;
    private long creationTime;
    private long expirationTime;
    private long lastAccessTime;
    private long hits;

    public WanCacheEntryView() {
    }

    public WanCacheEntryView(@Nonnull Data dataKey, @Nullable Data dataValue, long creationTime, long expirationTime, long lastAccessTime, long hits, @Nonnull SerializationService serializationService) {
        this.dataKey = dataKey;
        this.dataValue = dataValue;
        this.creationTime = creationTime;
        this.expirationTime = expirationTime;
        this.lastAccessTime = lastAccessTime;
        this.hits = hits;
        this.serializationService = serializationService;
    }

    @Override
    public K getKey() {
        if (this.key == null) {
            this.key = this.serializationService.toObject(this.dataKey);
        }
        return this.key;
    }

    public Data getDataKey() {
        return this.dataKey;
    }

    @Override
    public V getValue() {
        if (this.value == null) {
            this.value = this.serializationService.toObject(this.dataValue);
        }
        return this.value;
    }

    public Data getDataValue() {
        return this.dataValue;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public Data getExpiryPolicy() {
        return null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.creationTime);
        out.writeLong(this.expirationTime);
        out.writeLong(this.lastAccessTime);
        out.writeLong(this.hits);
        IOUtil.writeData(out, this.dataKey);
        IOUtil.writeData(out, this.dataValue);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.creationTime = in.readLong();
        this.expirationTime = in.readLong();
        this.lastAccessTime = in.readLong();
        this.hits = in.readLong();
        this.dataKey = IOUtil.readData(in);
        this.dataValue = IOUtil.readData(in);
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WanCacheEntryView that = (WanCacheEntryView)o;
        return this.creationTime == that.creationTime && this.expirationTime == that.expirationTime && this.lastAccessTime == that.lastAccessTime && this.hits == that.hits && this.dataKey.equals(that.dataKey) && this.dataValue.equals(that.dataValue);
    }

    public int hashCode() {
        return Objects.hash(this.dataKey, this.dataValue, this.creationTime, this.expirationTime, this.lastAccessTime, this.hits);
    }
}

