/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class ParseDefaultingDateTimeFormatter {
    private final AtomicReference<Wrapper> wrapperReference = new AtomicReference();
    private final Function<LocalDateTime, String> applicabilityTransform;
    private final Function<LocalDateTime, DateTimeFormatter> formatFactory;

    public ParseDefaultingDateTimeFormatter(Function<LocalDateTime, String> applicabilityTransform, Function<LocalDateTime, DateTimeFormatter> formatFactory) {
        this.applicabilityTransform = applicabilityTransform;
        this.formatFactory = formatFactory;
    }

    public DateTimeFormatter get() {
        LocalDateTime now = LocalDateTime.now();
        String applicabilityValue = this.applicabilityTransform.apply(now);
        Wrapper wrapper = this.wrapperReference.get();
        if (wrapper != null && wrapper.getApplicabilityValue().equals(applicabilityValue)) {
            return wrapper.getFormatter();
        }
        DateTimeFormatter formatter = this.formatFactory.apply(now);
        Wrapper updatedWrapper = new Wrapper(formatter, applicabilityValue);
        this.wrapperReference.compareAndSet(wrapper, updatedWrapper);
        return formatter;
    }

    private static class Wrapper {
        private final DateTimeFormatter formatter;
        private final String applicabilityValue;

        public Wrapper(DateTimeFormatter formatter, String applicabilityValue) {
            this.formatter = formatter;
            this.applicabilityValue = applicabilityValue;
        }

        public DateTimeFormatter getFormatter() {
            return this.formatter;
        }

        public String getApplicabilityValue() {
            return this.applicabilityValue;
        }
    }
}

