/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.io.File;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperInstance;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class ZooKeeperBase {
    protected static File tempDir;
    protected static ZooKeeperInstance instance;

    @BeforeClass
    public static void startZooKeeper() throws Exception {
        tempDir = new File("zookeeper");
        tempDir.mkdir();
        instance = new ZooKeeperInstance(8348, tempDir);
        instance.start();
    }

    @AfterClass
    public static void stopZookeeper() throws Exception {
        instance.stop();
        ZooKeeperBase.deleteRecursively(tempDir);
    }

    protected static void deleteRecursively(File tempDir) throws Exception {
        if (tempDir.isDirectory()) {
            File[] files;
            for (File f : files = tempDir.listFiles()) {
                ZooKeeperBase.deleteRecursively(f);
            }
        }
        tempDir.delete();
    }
}

