/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.assertions;

import java.io.PrintStream;
import java.lang.reflect.Type;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentBooleanAssertion;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.rest.httppart.RequestFormParam;

public class FluentRequestFormParamAssertion<R>
extends FluentStringAssertion<R> {
    private final RequestFormParam value;

    public FluentRequestFormParamAssertion(Assertion creator, RequestFormParam value, R returns) {
        super(creator, (String)value.asString().orElse(null), returns);
        this.value = value;
        this.setThrowable(BadRequest.class);
    }

    public FluentRequestFormParamAssertion(RequestFormParam value, R returns) {
        this((Assertion)null, value, returns);
    }

    public <T> FluentAnyAssertion<T, R> as(Class<T> type) {
        return new FluentAnyAssertion(this.value.as(type).orElse(null), this.returns());
    }

    public FluentAnyAssertion<Object, R> as(Type type, Type ... args) {
        return new FluentAnyAssertion(this.value.as(type, args).orElse(null), this.returns());
    }

    public FluentBooleanAssertion<R> asBoolean() {
        return new FluentBooleanAssertion((Assertion)this, this.value.asBoolean().orElse(null), this.returns());
    }

    public FluentIntegerAssertion<R> asInteger() {
        return new FluentIntegerAssertion((Assertion)this, this.value.asInteger().orElse(null), this.returns());
    }

    @Override
    public FluentRequestFormParamAssertion<R> asJavaStrings() {
        super.asJavaStrings();
        return this;
    }

    public FluentLongAssertion<R> asLong() {
        return new FluentLongAssertion((Assertion)this, this.value.asLong().orElse(null), this.returns());
    }

    public FluentZonedDateTimeAssertion<R> asZonedDateTime() {
        return new FluentZonedDateTimeAssertion((Assertion)this, this.value.asDatePart().asZonedDateTime().orElse(null), this.returns());
    }

    @Override
    public FluentRequestFormParamAssertion<R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentRequestFormParamAssertion<R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentRequestFormParamAssertion<R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentRequestFormParamAssertion<R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentRequestFormParamAssertion<R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }
}

