/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import org.apache.commons.lang3.StringUtils;
import org.apache.wiki.api.core.Command;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.GroupPermission;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.ui.GroupCommand;

public class PermissionTag
extends WikiTagBase {
    private static final String ALL_PERMISSION = "allPermission";
    private static final String CREATE_GROUPS = "createGroups";
    private static final String CREATE_PAGES = "createPages";
    private static final String DELETE_GROUP = "deleteGroup";
    private static final String EDIT = "edit";
    private static final String EDIT_GROUP = "editGroup";
    private static final String EDIT_PREFERENCES = "editPreferences";
    private static final String EDIT_PROFILE = "editProfile";
    private static final String LOGIN = "login";
    private static final String VIEW_GROUP = "viewGroup";
    private static final long serialVersionUID = 3761412993048982325L;
    private String[] m_permissionList;

    @Override
    public void initTag() {
        super.initTag();
        this.m_permissionList = null;
    }

    public void setPermission(String permission) {
        this.m_permissionList = StringUtils.split((String)permission, (char)'|');
    }

    private boolean checkPermission(String permission) {
        Session session = this.m_wikiContext.getWikiSession();
        Page page = this.m_wikiContext.getPage();
        AuthorizationManager mgr = (AuthorizationManager)this.m_wikiContext.getEngine().getManager(AuthorizationManager.class);
        boolean gotPermission = false;
        if (CREATE_GROUPS.equals(permission) || CREATE_PAGES.equals(permission) || EDIT_PREFERENCES.equals(permission) || EDIT_PROFILE.equals(permission) || LOGIN.equals(permission)) {
            gotPermission = mgr.checkPermission(session, new WikiPermission(page.getWiki(), permission));
        } else if (VIEW_GROUP.equals(permission) || EDIT_GROUP.equals(permission) || DELETE_GROUP.equals(permission)) {
            Command command = this.m_wikiContext.getCommand();
            gotPermission = false;
            if (command instanceof GroupCommand && command.getTarget() != null) {
                GroupPrincipal group = (GroupPrincipal)command.getTarget();
                String groupName = group.getName();
                String action = "view";
                if (EDIT_GROUP.equals(permission)) {
                    action = EDIT;
                } else if (DELETE_GROUP.equals(permission)) {
                    action = "delete";
                }
                gotPermission = mgr.checkPermission(session, new GroupPermission(groupName, action));
            }
        } else if (ALL_PERMISSION.equals(permission)) {
            gotPermission = mgr.checkPermission(session, new AllPermission(this.m_wikiContext.getEngine().getApplicationName()));
        } else if (page != null) {
            if (EDIT.equals(permission)) {
                Page latest = ((PageManager)this.m_wikiContext.getEngine().getManager(PageManager.class)).getPage(page.getName());
                if (page.getVersion() != -1 && latest.getVersion() != page.getVersion()) {
                    return false;
                }
            }
            PagePermission p = PermissionFactory.getPagePermission(page, permission);
            gotPermission = mgr.checkPermission(session, p);
        }
        return gotPermission;
    }

    @Override
    public final int doWikiStartTag() {
        for (String perm : this.m_permissionList) {
            boolean hasPermission = perm.charAt(0) == '!' ? !this.checkPermission(perm.substring(1)) : this.checkPermission(perm);
            if (!hasPermission) continue;
            return 1;
        }
        return 0;
    }
}

