/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.forms;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.forms.FormElement;
import org.apache.wiki.forms.FormInfo;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.XhtmlUtil;
import org.jdom2.Element;

public class FormInput
extends FormElement {
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_SIZE = "size";
    public static final String PARAM_CHECKED = "checked";

    public String execute(Context ctx, Map<String, String> params) throws PluginException {
        String inputName = params.get("name");
        String inputValue = params.get("value");
        String inputType = params.get(PARAM_TYPE);
        String size = params.get(PARAM_SIZE);
        String checked = params.get(PARAM_CHECKED);
        ResourceBundle rb = Preferences.getBundle(ctx, "plugin.PluginResources");
        if (inputName == null) {
            throw new PluginException(rb.getString("forminput.namemissing"));
        }
        if (inputValue == null) {
            inputValue = "";
        }
        FormInfo info = this.getFormInfo(ctx);
        Map<String, String> previousValues = null;
        if (info != null) {
            if (info.hide()) {
                return "<p>" + rb.getString("forminput.noneedtoshow") + "</p>";
            }
            previousValues = info.getSubmission();
        }
        if (previousValues == null) {
            previousValues = new HashMap<String, String>();
        }
        Element field = XhtmlUtil.input((String)inputType, (String)("nbf_" + inputName), (String)inputValue);
        field.setAttribute("class", String.valueOf(TextUtil.isPositive((String)checked) || PARAM_CHECKED.equalsIgnoreCase(checked)));
        String oldValue = previousValues.get(inputName);
        if (oldValue != null) {
            field.setAttribute("value", oldValue);
        }
        if (size != null) {
            field.setAttribute(PARAM_SIZE, size);
        }
        return XhtmlUtil.serialize((Element)field);
    }
}

