/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.util.Stopwatch;

public class Debug {
    public static String DEBUG_PROPERTY_NAME = "jts.debug";
    public static String DEBUG_PROPERTY_VALUE_ON = "on";
    public static String DEBUG_PROPERTY_VALUE_TRUE = "true";
    private static boolean debugOn = false;
    private static Stopwatch stopwatch;
    private static long lastTimePrinted;
    private static final Debug debug;
    private static final GeometryFactory fact;
    private static final String DEBUG_LINE_TAG = "D! ";
    private PrintStream out;
    private Class[] printArgs;
    private Object watchObj = null;
    private Object[] args = new Object[1];

    public static void main(String[] args) {
        System.out.println("JTS Debugging is " + (debugOn ? "ON" : "OFF"));
    }

    public static boolean isDebugging() {
        return debugOn;
    }

    public static LineString toLine(Coordinate p0, Coordinate p1) {
        return fact.createLineString(new Coordinate[]{p0, p1});
    }

    public static LineString toLine(Coordinate p0, Coordinate p1, Coordinate p2) {
        return fact.createLineString(new Coordinate[]{p0, p1, p2});
    }

    public static LineString toLine(Coordinate p0, Coordinate p1, Coordinate p2, Coordinate p3) {
        return fact.createLineString(new Coordinate[]{p0, p1, p2, p3});
    }

    public static void print(String str2) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(str2);
    }

    public static void print(Object obj) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(obj);
    }

    public static void print(boolean isTrue, Object obj) {
        if (!debugOn) {
            return;
        }
        if (!isTrue) {
            return;
        }
        debug.instancePrint(obj);
    }

    public static void println(Object obj) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(obj);
        debug.println();
    }

    public static void resetTime() {
        stopwatch.reset();
        lastTimePrinted = stopwatch.getTime();
    }

    public static void printTime(String tag) {
        if (!debugOn) {
            return;
        }
        long time = stopwatch.getTime();
        long elapsedTime = time - lastTimePrinted;
        debug.instancePrint(Debug.formatField(Stopwatch.getTimeString(time), 10) + " (" + Debug.formatField(Stopwatch.getTimeString(elapsedTime), 10) + " ) " + tag);
        debug.println();
        lastTimePrinted = time;
    }

    private static String formatField(String s, int fieldLen) {
        int nPad = fieldLen - s.length();
        if (nPad <= 0) {
            return s;
        }
        String padStr = Debug.spaces(nPad) + s;
        return padStr.substring(padStr.length() - fieldLen);
    }

    private static String spaces(int n) {
        char[] ch = new char[n];
        for (int i = 0; i < n; ++i) {
            ch[i] = 32;
        }
        return new String(ch);
    }

    public static boolean equals(Coordinate c1, Coordinate c2, double tolerance) {
        return c1.distance(c2) <= tolerance;
    }

    public static void addWatch(Object obj) {
        debug.instanceAddWatch(obj);
    }

    public static void printWatch() {
        debug.instancePrintWatch();
    }

    public static void printIfWatch(Object obj) {
        debug.instancePrintIfWatch(obj);
    }

    public static void breakIf(boolean cond) {
        if (cond) {
            Debug.doBreak();
        }
    }

    public static void breakIfEqual(Object o1, Object o2) {
        if (o1.equals(o2)) {
            Debug.doBreak();
        }
    }

    public static void breakIfEqual(Coordinate p0, Coordinate p1, double tolerance) {
        if (p0.distance(p1) <= tolerance) {
            Debug.doBreak();
        }
    }

    private static void doBreak() {
    }

    public static boolean hasSegment(Geometry geom, Coordinate p0, Coordinate p1) {
        SegmentFindingFilter filter = new SegmentFindingFilter(p0, p1);
        geom.apply(filter);
        return filter.hasSegment();
    }

    private Debug() {
        this.out = System.out;
        this.printArgs = new Class[1];
        try {
            this.printArgs[0] = Class.forName("java.io.PrintStream");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void instancePrintWatch() {
        if (this.watchObj == null) {
            return;
        }
        this.instancePrint(this.watchObj);
    }

    public void instancePrintIfWatch(Object obj) {
        if (obj != this.watchObj) {
            return;
        }
        if (this.watchObj == null) {
            return;
        }
        this.instancePrint(this.watchObj);
    }

    public void instancePrint(Object obj) {
        if (obj instanceof Collection) {
            this.instancePrint(((Collection)obj).iterator());
        } else if (obj instanceof Iterator) {
            this.instancePrint((Iterator)obj);
        } else {
            this.instancePrintObject(obj);
        }
    }

    public void instancePrint(Iterator it) {
        while (it.hasNext()) {
            Object obj = it.next();
            this.instancePrintObject(obj);
        }
    }

    public void instancePrintObject(Object obj) {
        Method printMethod = null;
        try {
            Class<?> cls = obj.getClass();
            try {
                printMethod = cls.getMethod("print", this.printArgs);
                this.args[0] = this.out;
                this.out.print(DEBUG_LINE_TAG);
                printMethod.invoke(obj, this.args);
            }
            catch (NoSuchMethodException ex) {
                this.instancePrint(obj.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(this.out);
        }
    }

    public void println() {
        this.out.println();
    }

    private void instanceAddWatch(Object obj) {
        this.watchObj = obj;
    }

    private void instancePrint(String str2) {
        this.out.print(DEBUG_LINE_TAG);
        this.out.print(str2);
    }

    static {
        String debugValue = System.getProperty(DEBUG_PROPERTY_NAME);
        if (debugValue != null && (debugValue.equalsIgnoreCase(DEBUG_PROPERTY_VALUE_ON) || debugValue.equalsIgnoreCase(DEBUG_PROPERTY_VALUE_TRUE))) {
            debugOn = true;
        }
        stopwatch = new Stopwatch();
        debug = new Debug();
        fact = new GeometryFactory();
    }

    private static class SegmentFindingFilter
    implements CoordinateSequenceFilter {
        private Coordinate p0;
        private Coordinate p1;
        private boolean hasSegment = false;

        public SegmentFindingFilter(Coordinate p0, Coordinate p1) {
            this.p0 = p0;
            this.p1 = p1;
        }

        public boolean hasSegment() {
            return this.hasSegment;
        }

        @Override
        public void filter(CoordinateSequence seq2, int i) {
            if (i == 0) {
                return;
            }
            this.hasSegment = this.p0.equals2D(seq2.getCoordinate(i - 1)) && this.p1.equals2D(seq2.getCoordinate(i));
        }

        @Override
        public boolean isDone() {
            return this.hasSegment;
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }
    }
}

