/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;

public final class TaskExecutor {
    private final Executor executor;

    public TaskExecutor(Executor executor) {
        Objects.requireNonNull(executor, "Executor is null");
        this.executor = r -> {
            try {
                executor.execute(r);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                r.run();
            }
        };
    }

    public <T> List<T> invokeAll(Collection<Callable<T>> callables) throws IOException {
        int id;
        ArrayList futures = new ArrayList(callables.size());
        for (Callable<T> callable : callables) {
            futures.add(new Task<T>(callable, futures));
        }
        int count = futures.size();
        AtomicInteger taskId = new AtomicInteger(0);
        if (count > 1) {
            Runnable work = () -> {
                int id = taskId.getAndIncrement();
                if (id < count) {
                    ((RunnableFuture)futures.get(id)).run();
                }
            };
            for (int j = 0; j < count - 1; ++j) {
                this.executor.execute(work);
            }
        }
        while ((id = taskId.getAndIncrement()) < count) {
            ((RunnableFuture)futures.get(id)).run();
            if (id < count - 1) continue;
            break;
        }
        return TaskExecutor.collectResults(futures);
    }

    private static <T> List<T> collectResults(List<RunnableFuture<T>> futures) throws IOException {
        Throwable exc = null;
        ArrayList results = new ArrayList(futures.size());
        for (Future future : futures) {
            try {
                results.add(future.get());
            }
            catch (InterruptedException e2) {
                exc = IOUtils.useOrSuppress(exc, new ThreadInterruptedException(e2));
            }
            catch (ExecutionException e3) {
                exc = IOUtils.useOrSuppress(exc, e3.getCause());
            }
        }
        assert (TaskExecutor.assertAllFuturesCompleted(futures)) : "Some tasks are still running?";
        if (exc != null) {
            throw IOUtils.rethrowAlways(exc);
        }
        return results;
    }

    public String toString() {
        return "TaskExecutor(executor=" + String.valueOf(this.executor) + ")";
    }

    private static boolean assertAllFuturesCompleted(Collection<? extends Future<?>> futures) {
        for (Future<?> future : futures) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    private static <T> void cancelAll(Collection<? extends Future<T>> futures) {
        for (Future<T> future : futures) {
            future.cancel(false);
        }
    }

    private static class Task<T>
    extends FutureTask<T> {
        private final AtomicBoolean startedOrCancelled = new AtomicBoolean(false);
        private final Collection<? extends Future<T>> futures;

        public Task(Callable<T> callable, Collection<? extends Future<T>> futures) {
            super(callable);
            this.futures = futures;
        }

        @Override
        public void run() {
            if (this.startedOrCancelled.compareAndSet(false, true)) {
                super.run();
            }
        }

        @Override
        protected void setException(Throwable t) {
            super.setException(t);
            TaskExecutor.cancelAll(this.futures);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            assert (!mayInterruptIfRunning) : "cancelling tasks that are running is not supported";
            if (this.startedOrCancelled.compareAndSet(false, true)) {
                this.set(null);
                return true;
            }
            return false;
        }
    }
}

