/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheusmetrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.NamingConvention;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MicrometerCollector
implements MultiCollector {
    private final Map<List<String>, Child> children = new ConcurrentHashMap<List<String>, Child>();
    private final String conventionName;
    private final Meter.Type meterType;
    private final List<String> tagKeys;

    MicrometerCollector(String name, Meter.Id id, NamingConvention convention) {
        this.conventionName = name;
        this.meterType = id.getType();
        this.tagKeys = id.getConventionTags(convention).stream().map(Tag::getKey).collect(Collectors.toList());
    }

    public void add(List<String> tagValues, Child child) {
        this.children.put(tagValues, child);
    }

    public void remove(List<String> tagValues) {
        this.children.remove(tagValues);
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public List<String> getTagKeys() {
        return this.tagKeys;
    }

    Meter.Type getMeterType() {
        return this.meterType;
    }

    @Override
    public MetricSnapshots collect() {
        HashMap families = new HashMap();
        for (Child child : this.children.values()) {
            child.samples(this.conventionName, this.tagKeys).forEach(family -> families.compute(family.getConventionName(), (name, matchingFamily) -> matchingFamily != null ? matchingFamily.addSamples(family.dataPointSnapshots) : family));
        }
        Collection metricSnapshots = families.values().stream().map(Family::toMetricSnapshot).collect(Collectors.toList());
        return new MetricSnapshots(metricSnapshots);
    }

    static interface Child {
        public Stream<Family<?>> samples(String var1, List<String> var2);
    }

    static class Family<T extends DataPointSnapshot> {
        final String conventionName;
        final MetricMetadata metadata;
        final List<T> dataPointSnapshots = new ArrayList<T>();
        final Function<Family<T>, MetricSnapshot> metricSnapshotFactory;

        Family(String conventionName, Function<Family<T>, MetricSnapshot> metricSnapshotFactory, MetricMetadata metadata, T ... dataPointSnapshots) {
            this.conventionName = conventionName;
            this.metricSnapshotFactory = metricSnapshotFactory;
            this.metadata = metadata;
            Collections.addAll(this.dataPointSnapshots, dataPointSnapshots);
        }

        String getConventionName() {
            return this.conventionName;
        }

        Family<T> addSamples(Collection<T> dataPointSnapshots) {
            this.dataPointSnapshots.addAll(dataPointSnapshots);
            return this;
        }

        MetricSnapshot toMetricSnapshot() {
            return this.metricSnapshotFactory.apply(this);
        }
    }
}

