/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.solver;

import java.util.function.Predicate;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Graph;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.main.StageGenerator;
import org.apache.jena.tdb2.solver.PatternMatchTDB2;
import org.apache.jena.tdb2.solver.QC2;
import org.apache.jena.tdb2.store.GraphTDB;
import org.apache.jena.tdb2.store.GraphViewSwitchable;
import org.apache.jena.tdb2.store.NodeId;

public class StageGeneratorDirectTDB
implements StageGenerator {
    StageGenerator above = null;

    public StageGeneratorDirectTDB(StageGenerator original) {
        this.above = original;
    }

    @Override
    public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        Graph g = execCxt.getActiveGraph();
        if (g instanceof GraphViewSwitchable) {
            GraphViewSwitchable gvs = (GraphViewSwitchable)g;
            g = gvs.getBaseGraph();
        }
        if (!(g instanceof GraphTDB)) {
            return this.above.execute(pattern, input, execCxt);
        }
        GraphTDB graph = (GraphTDB)g;
        Predicate<Tuple<NodeId>> filter = QC2.getFilter(execCxt.getContext());
        return PatternMatchTDB2.execute(graph, pattern, input, filter, execCxt);
    }
}

