/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.main;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import org.apache.jena.atlas.lib.ArrayUtils;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.query.TxnType;
import org.apache.jena.system.progress.MonitorOutput;
import org.apache.jena.tdb2.loader.base.BulkStartFinish;
import org.apache.jena.tdb2.loader.base.CoLib;
import org.apache.jena.tdb2.loader.main.Destination;
import org.apache.jena.tdb2.loader.main.PhasedOps;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;

public class Indexer
implements BulkStartFinish {
    private BlockingQueue<List<Tuple<NodeId>>>[] pipesTripleIndexers;
    private final int N;
    private final MonitorOutput output;
    private TupleIndex[] indexes;
    private final Semaphore termination = new Semaphore(0);

    public Indexer(MonitorOutput output, TupleIndex ... idxTriples) {
        this.pipesTripleIndexers = ArrayUtils.alloc(BlockingQueue.class, idxTriples.length);
        this.N = idxTriples.length;
        this.indexes = Arrays.copyOf(idxTriples, this.N);
        this.output = output;
        for (int i = 0; i < this.N; ++i) {
            this.pipesTripleIndexers[i] = new ArrayBlockingQueue<List<Tuple<NodeId>>>(10);
        }
    }

    public Destination<Tuple<NodeId>> index() {
        return this::index;
    }

    private void index(List<Tuple<NodeId>> chunk) {
        for (int i = 0; i < this.N; ++i) {
            try {
                this.pipesTripleIndexers[i].put(chunk);
                continue;
            }
            catch (InterruptedException e2) {
                String name = this.indexes[i].getName();
                Log.error(this, "Interrupted: " + name, e2);
                throw new RuntimeException(e2);
            }
        }
    }

    @Override
    public void startBulk() {
        for (int i = 0; i < this.N; ++i) {
            TupleIndex idx = this.indexes[i];
            BlockingQueue<List<Tuple<NodeId>>> pipe = this.pipesTripleIndexers[i];
            new Thread(() -> this.stageIndex(pipe, idx)).start();
        }
    }

    @Override
    public void finishBulk() {
        PhasedOps.acquire(this.termination, this.N);
    }

    private void stageIndex(BlockingQueue<List<Tuple<NodeId>>> pipe, TupleIndex idx) {
        boolean workHasBeenDone;
        TransactionCoordinator coordinator = CoLib.newCoordinator();
        CoLib.add(coordinator, idx);
        CoLib.start(coordinator);
        Transaction transaction = coordinator.begin(TxnType.WRITE);
        try {
            List<Tuple<NodeId>> tuples;
            Destination<Tuple<NodeId>> loader = Indexer.loadTuples(idx);
            while (!(tuples = pipe.take()).isEmpty()) {
                loader.deliver(tuples);
            }
            workHasBeenDone = !idx.isEmpty();
            transaction.commit();
        }
        catch (Exception ex) {
            Log.error(this, "Interrupted", ex);
            transaction.abort();
            workHasBeenDone = false;
        }
        CoLib.finish(coordinator);
        if (workHasBeenDone) {
            this.output.print("Finish - index %s", idx.getName());
        }
        this.termination.release();
    }

    private static Destination<Tuple<NodeId>> loadTuples(TupleIndex index) {
        return tuples -> {
            for (Tuple tuple : tuples) {
                index.add(tuple);
            }
        };
    }
}

